/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.java;

import org.graalvm.compiler.core.common.type.StampFactory;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;

@NodeInfo(allowedUsageTypes={InputType.Association}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public class MonitorIdNode
extends ValueNode
implements IterableNodeType,
LIRLowerable {
    public static final NodeClass<MonitorIdNode> TYPE = NodeClass.create(MonitorIdNode.class);
    protected int lockDepth;
    protected boolean eliminated;
    protected final int bci;
    protected boolean multipleEntry;

    public MonitorIdNode(int lockDepth, int bci) {
        this(TYPE, lockDepth, bci);
    }

    public MonitorIdNode(int lockDepth, int bci, boolean multipleEntry) {
        this(TYPE, lockDepth, bci);
        this.multipleEntry = multipleEntry;
    }

    public MonitorIdNode(int lockDepth) {
        this(TYPE, lockDepth, -1);
    }

    protected MonitorIdNode(NodeClass<? extends MonitorIdNode> c, int lockDepth, int bci) {
        super(c, StampFactory.forVoid());
        this.lockDepth = lockDepth;
        this.bci = bci;
    }

    public int getBci() {
        return this.bci;
    }

    public void setMultipleEntry() {
        this.multipleEntry = true;
    }

    public boolean isMultipleEntry() {
        return this.multipleEntry;
    }

    public int getLockDepth() {
        return this.lockDepth;
    }

    public void setLockDepth(int lockDepth) {
        this.lockDepth = lockDepth;
    }

    public boolean isEliminated() {
        return this.eliminated;
    }

    public void setEliminated() {
        this.eliminated = true;
    }

    @Override
    public void generate(NodeLIRBuilderTool generator) {
    }

    public static boolean monitorIdentityEquals(MonitorIdNode m1, MonitorIdNode m2) {
        if (m1 == m2) {
            return true;
        }
        return m1.getLockDepth() == m2.getLockDepth() && m1.getBci() == m2.getBci();
    }
}

