/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes.calc;

import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.core.common.type.ArithmeticOpTable;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.ConstantNode;
import org.graalvm.compiler.nodes.LogicNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.calc.ConditionalNode;
import org.graalvm.compiler.nodes.calc.IntegerLessThanNode;
import org.graalvm.compiler.nodes.calc.MinMaxNode;
import org.graalvm.compiler.nodes.spi.LoweringProvider;

@NodeInfo(shortName="Max")
public class MaxNode
extends MinMaxNode<ArithmeticOpTable.BinaryOp.Max> {
    public static final NodeClass<MaxNode> TYPE = NodeClass.create(MaxNode.class);

    protected MaxNode(ValueNode x, ValueNode y) {
        super(TYPE, MaxNode.getArithmeticOpTable(x).getMax(), x, y);
    }

    @Override
    protected ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Max> getOp(ArithmeticOpTable table) {
        return table.getMax();
    }

    public static ValueNode create(ValueNode x, ValueNode y, NodeView view) {
        Stamp stamp;
        ArithmeticOpTable.BinaryOp<ArithmeticOpTable.BinaryOp.Max> op = ArithmeticOpTable.forStamp(x.stamp(view)).getMax();
        ConstantNode tryConstantFold = MaxNode.tryConstantFold(op, x, y, stamp = op.foldStamp(x.stamp(view), y.stamp(view)), view);
        if (tryConstantFold != null) {
            return tryConstantFold;
        }
        return new MaxNode(x, y).maybeCommuteInputs();
    }

    @Override
    public ValueNode asConditional(LoweringProvider lowerer) {
        if (!this.stamp(NodeView.DEFAULT).isIntegerStamp()) {
            return null;
        }
        LogicNode condition = IntegerLessThanNode.create(MaxNode.maybeExtendForCompare(this.getX(), lowerer, NumUtil.Signedness.SIGNED), MaxNode.maybeExtendForCompare(this.getY(), lowerer, NumUtil.Signedness.SIGNED), NodeView.DEFAULT);
        return ConditionalNode.create(condition, this.getY(), this.getX(), NodeView.DEFAULT);
    }

    @Override
    public boolean isNarrowable(int resultBits) {
        if (!super.isNarrowable(resultBits)) {
            return false;
        }
        return super.isNarrowable(resultBits, NumUtil.Signedness.SIGNED);
    }
}

