/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.nodes;

import java.util.List;
import org.graalvm.compiler.debug.DebugCloseable;
import org.graalvm.compiler.graph.IterableNodeType;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.graph.NodeInputList;
import org.graalvm.compiler.graph.iterators.NodeIterable;
import org.graalvm.compiler.nodeinfo.InputType;
import org.graalvm.compiler.nodeinfo.NodeCycles;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodeinfo.NodeSize;
import org.graalvm.compiler.nodes.AbstractEndNode;
import org.graalvm.compiler.nodes.BeginStateSplitNode;
import org.graalvm.compiler.nodes.EndNode;
import org.graalvm.compiler.nodes.FixedNode;
import org.graalvm.compiler.nodes.FrameState;
import org.graalvm.compiler.nodes.GraphState;
import org.graalvm.compiler.nodes.LoopBeginNode;
import org.graalvm.compiler.nodes.LoopEndNode;
import org.graalvm.compiler.nodes.MergeNode;
import org.graalvm.compiler.nodes.PhiNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.ValuePhiNode;
import org.graalvm.compiler.nodes.VirtualState;
import org.graalvm.compiler.nodes.memory.MemoryPhiNode;
import org.graalvm.compiler.nodes.spi.LIRLowerable;
import org.graalvm.compiler.nodes.spi.NodeLIRBuilderTool;
import org.graalvm.compiler.nodes.spi.Simplifiable;
import org.graalvm.compiler.nodes.spi.SimplifierTool;
import org.graalvm.compiler.nodes.util.GraphUtil;

@NodeInfo(allowedUsageTypes={InputType.Association}, cycles=NodeCycles.CYCLES_0, size=NodeSize.SIZE_0)
public abstract class AbstractMergeNode
extends BeginStateSplitNode
implements IterableNodeType,
Simplifiable,
LIRLowerable {
    public static final NodeClass<AbstractMergeNode> TYPE = NodeClass.create(AbstractMergeNode.class);
    @Node.Input(value=InputType.Association)
    protected NodeInputList<EndNode> ends = new NodeInputList(this);

    protected AbstractMergeNode(NodeClass<? extends AbstractMergeNode> c) {
        super((NodeClass<? extends BeginStateSplitNode>)c);
    }

    @Override
    public void generate(NodeLIRBuilderTool gen) {
        gen.visitMerge(this);
    }

    public int forwardEndIndex(EndNode end) {
        return this.ends.indexOf(end);
    }

    public void addForwardEnd(EndNode end) {
        this.ends.add((Object)end);
    }

    public final int forwardEndCount() {
        return this.ends.size();
    }

    public final EndNode forwardEndAt(int index) {
        return (EndNode)this.ends.get(index);
    }

    public NodeIterable<EndNode> cfgPredecessors() {
        return this.ends;
    }

    public boolean isPhiAtMerge(Node value) {
        return value instanceof PhiNode && ((PhiNode)value).merge() == this;
    }

    public void removeEnd(AbstractEndNode pred) {
        int predIndex = this.phiPredecessorIndex(pred);
        assert (predIndex != -1);
        this.deleteEnd(pred);
        for (PhiNode phi : this.phis().snapshot()) {
            if (phi.isDeleted()) continue;
            ValueNode removedValue = phi.valueAt(predIndex);
            phi.removeInput(predIndex);
            if (removedValue == null) continue;
            GraphUtil.tryKillUnused(removedValue);
        }
    }

    protected void deleteEnd(AbstractEndNode end) {
        this.ends.remove(end);
    }

    public void clearEnds() {
        this.ends.clear();
    }

    public NodeInputList<EndNode> forwardEnds() {
        return this.ends;
    }

    public int phiPredecessorCount() {
        return this.forwardEndCount();
    }

    public int phiPredecessorIndex(AbstractEndNode pred) {
        return this.forwardEndIndex((EndNode)pred);
    }

    public AbstractEndNode phiPredecessorAt(int index) {
        return this.forwardEndAt(index);
    }

    public NodeIterable<PhiNode> phis() {
        return this.usages().filter(PhiNode.class).filter(this::isPhiAtMerge);
    }

    public NodeIterable<ValuePhiNode> valuePhis() {
        return this.usages().filter(ValuePhiNode.class);
    }

    public NodeIterable<MemoryPhiNode> memoryPhis() {
        return this.usages().filter(MemoryPhiNode.class);
    }

    @Override
    public NodeIterable<Node> anchored() {
        return super.anchored().filter(n -> !this.isPhiAtMerge(n));
    }

    @Override
    public void simplify(SimplifierTool tool) {
        FixedNode currentNext = this.next();
        if (currentNext instanceof AbstractEndNode) {
            AbstractEndNode origLoopEnd = (AbstractEndNode)currentNext;
            AbstractMergeNode merge = origLoopEnd.merge();
            if (merge instanceof LoopBeginNode && !(origLoopEnd instanceof LoopEndNode)) {
                return;
            }
            if (this.anchored().isNotEmpty()) {
                return;
            }
            if (merge.stateAfter() == null && this.stateAfter() != null) {
                return;
            }
            for (PhiNode phi : this.phis()) {
                for (Node usage : phi.usages()) {
                    if (usage instanceof VirtualState || merge.isPhiAtMerge(usage)) continue;
                    return;
                }
            }
            this.getDebug().log("Split %s into ends for %s.", (Object)this, (Object)merge);
            int numEnds = this.forwardEndCount();
            for (int i = 0; i < numEnds - 1; ++i) {
                AbstractEndNode newEnd;
                EndNode end = this.forwardEndAt(numEnds - 1 - i);
                if (tool != null) {
                    tool.addToWorkList(end);
                }
                try (DebugCloseable position = end.withNodeSourcePosition();){
                    if (merge instanceof LoopBeginNode) {
                        newEnd = this.graph().add(new LoopEndNode((LoopBeginNode)merge));
                    } else {
                        EndNode tmpEnd = this.graph().add(new EndNode());
                        merge.addForwardEnd(tmpEnd);
                        newEnd = tmpEnd;
                    }
                }
                for (PhiNode phi : merge.phis()) {
                    ValueNode newInput;
                    ValueNode v = phi.valueAt(origLoopEnd);
                    if (this.isPhiAtMerge(v)) {
                        PhiNode endPhi = (PhiNode)v;
                        newInput = endPhi.valueAt(end);
                    } else {
                        newInput = v;
                    }
                    phi.addInput(newInput);
                }
                this.removeEnd(end);
                end.replaceAtPredecessor(newEnd);
                end.safeDelete();
                if (tool == null) continue;
                tool.addToWorkList(newEnd.predecessor());
            }
            this.graph().reduceTrivialMerge(this);
        }
    }

    public static boolean duplicateReturnThroughMerge(MergeNode merge) {
        assert (merge.graph() != null);
        FixedNode next = merge.next();
        if (next instanceof ReturnNode) {
            ReturnNode returnNode = (ReturnNode)next;
            if (merge.anchored().isNotEmpty() || returnNode.getMemoryMap() != null) {
                return false;
            }
            List<PhiNode> phis = merge.phis().snapshot();
            for (PhiNode phi : phis) {
                for (Node usage : phi.usages()) {
                    if (usage == returnNode || usage instanceof FrameState) continue;
                    return false;
                }
            }
            ValuePhiNode returnValuePhi = returnNode.result() == null || !merge.isPhiAtMerge(returnNode.result()) ? null : (ValuePhiNode)returnNode.result();
            List endNodes = merge.forwardEnds().snapshot();
            for (EndNode end : endNodes) {
                DebugCloseable position = returnNode.withNodeSourcePosition();
                try {
                    ReturnNode newReturn = merge.graph().add(new ReturnNode(returnValuePhi == null ? returnNode.result() : returnValuePhi.valueAt(end)));
                    end.replaceAtPredecessor(newReturn);
                }
                finally {
                    if (position == null) continue;
                    position.close();
                }
            }
            GraphUtil.killCFG(merge);
            for (EndNode end : endNodes) {
                end.safeDelete();
            }
            for (PhiNode phi : phis) {
                if (!phi.isAlive() || !phi.hasNoUsages()) continue;
                GraphUtil.killWithUnusedFloatingInputs(phi);
            }
            return true;
        }
        return false;
    }

    protected boolean verifyState() {
        return this.stateAfter != null;
    }

    @Override
    public boolean verify() {
        assert (!this.graph().getGraphState().getFrameStateVerification().implies(GraphState.FrameStateVerificationFeature.MERGES) || this.verifyState()) : "Merge must have a state until FSA " + this;
        return super.verify();
    }
}

