/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.util;

import java.util.function.BiConsumer;
import jdk.vm.ci.code.Architecture;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterArray;

public class RegisterMap<T> {
    private final Object[] values;
    private final Architecture architecture;

    public RegisterMap(Architecture arch) {
        assert (RegisterMap.checkArchitecture(arch));
        this.values = new Object[arch.getRegisters().size()];
        this.architecture = arch;
    }

    public T get(Register reg) {
        return (T)this.values[RegisterMap.index(reg)];
    }

    public void remove(Register reg) {
        this.values[RegisterMap.index((Register)reg)] = null;
    }

    public void put(Register reg, T value) {
        this.values[RegisterMap.index((Register)reg)] = value;
    }

    public void forEach(BiConsumer<? super Register, ? super T> consumer) {
        for (int i = 0; i < this.values.length; ++i) {
            Object value = this.values[i];
            if (value == null) continue;
            consumer.accept((Register)((Register)this.architecture.getRegisters().get(i)), (Register)value);
        }
    }

    private static int index(Register reg) {
        return reg.number;
    }

    private static boolean checkArchitecture(Architecture arch) {
        RegisterArray registers = arch.getRegisters();
        for (int i = 0; i < registers.size(); ++i) {
            assert (registers.get((int)i).number == i) : registers.get(i) + ": " + registers.get((int)i).number + "!=" + i;
        }
        return true;
    }
}

