/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.stackslotalloc;

import jdk.vm.ci.code.StackSlot;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.debug.Indent;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.ValueProcedure;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.framemap.FrameMapBuilderTool;
import org.graalvm.compiler.lir.framemap.SimpleVirtualStackSlot;
import org.graalvm.compiler.lir.framemap.SimpleVirtualStackSlotAlias;
import org.graalvm.compiler.lir.framemap.VirtualStackSlotRange;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.AllocationPhase;
import org.graalvm.compiler.lir.stackslotalloc.StackSlotAllocatorUtil;

public class SimpleStackSlotAllocator
extends AllocationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, AllocationPhase.AllocationContext context) {
        this.allocateStackSlots((FrameMapBuilderTool)lirGenRes.getFrameMapBuilder(), lirGenRes);
        lirGenRes.buildFrameMap();
    }

    public void allocateStackSlots(FrameMapBuilderTool builder, LIRGenerationResult res) {
        DebugContext debug = res.getLIR().getDebug();
        StackSlot[] mapping = new StackSlot[builder.getNumberOfStackSlots()];
        boolean allocatedFramesizeEnabled = StackSlotAllocatorUtil.allocatedFramesize.isEnabled(debug);
        long currentFrameSize = allocatedFramesizeEnabled ? (long)builder.getFrameMap().currentFrameSize() : 0L;
        for (VirtualStackSlot virtualSlot : builder.getStackSlots()) {
            StackSlot slot;
            ValueKind slotKind;
            if (virtualSlot instanceof SimpleVirtualStackSlot) {
                slotKind = virtualSlot.getValueKind();
                slot = builder.getFrameMap().allocateSpillSlot(slotKind);
                StackSlotAllocatorUtil.virtualFramesize.add(debug, builder.getFrameMap().spillSlotSize(slotKind));
            } else if (virtualSlot instanceof SimpleVirtualStackSlotAlias) {
                slotKind = ((SimpleVirtualStackSlotAlias)virtualSlot).getAliasedSlot().getValueKind();
                slot = builder.getFrameMap().allocateSpillSlot(slotKind);
                StackSlotAllocatorUtil.virtualFramesize.add(debug, builder.getFrameMap().spillSlotSize(slotKind));
            } else if (virtualSlot instanceof VirtualStackSlotRange) {
                VirtualStackSlotRange slotRange = (VirtualStackSlotRange)virtualSlot;
                slot = builder.getFrameMap().allocateStackMemory(slotRange.getSizeInBytes(), slotRange.getAlignmentInBytes());
                StackSlotAllocatorUtil.virtualFramesize.add(debug, slotRange.getSizeInBytes());
            } else {
                throw GraalError.shouldNotReachHere("Unknown VirtualStackSlot: " + virtualSlot);
            }
            StackSlotAllocatorUtil.allocatedSlots.increment(debug);
            mapping[virtualSlot.getId()] = slot;
        }
        this.updateLIR(res, mapping);
        if (allocatedFramesizeEnabled) {
            StackSlotAllocatorUtil.allocatedFramesize.add(debug, (long)builder.getFrameMap().currentFrameSize() - currentFrameSize);
        }
    }

    protected void updateLIR(LIRGenerationResult res, StackSlot[] mapping) {
        DebugContext debug = res.getLIR().getDebug();
        try (DebugContext.Scope scope = debug.scope("StackSlotMappingLIR");){
            ValueProcedure updateProc = (value, mode, flags) -> {
                if (LIRValueUtil.isVirtualStackSlot(value)) {
                    StackSlot stackSlot = mapping[LIRValueUtil.asVirtualStackSlot(value).getId()];
                    if (value instanceof SimpleVirtualStackSlotAlias) {
                        GraalError.guarantee(mode == LIRInstruction.OperandMode.USE || mode == LIRInstruction.OperandMode.ALIVE, "Invalid application of SimpleVirtualStackSlotAlias");
                        stackSlot = StackSlot.get((ValueKind)value.getValueKind(), (int)stackSlot.getRawOffset(), (boolean)stackSlot.getRawAddFrameSize());
                    }
                    debug.log("map %s -> %s", (Object)value, (Object)stackSlot);
                    return stackSlot;
                }
                return value;
            };
            for (AbstractBlockBase block : res.getLIR().getControlFlowGraph().getBlocks()) {
                try (Indent indent0 = debug.logAndIndent("block: %s", block);){
                    for (LIRInstruction inst : res.getLIR().getLIRforBlock(block)) {
                        Indent indent1 = debug.logAndIndent("Inst: %d: %s", inst.id(), (Object)inst);
                        try {
                            inst.forEachAlive(updateProc);
                            inst.forEachInput(updateProc);
                            inst.forEachOutput(updateProc);
                            inst.forEachTemp(updateProc);
                            inst.forEachState(updateProc);
                        }
                        finally {
                            if (indent1 == null) continue;
                            indent1.close();
                        }
                    }
                }
            }
        }
    }
}

