/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.profiling;

import java.util.ArrayList;
import java.util.List;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.lir.ConstantValue;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInsertionBuffer;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.gen.DiagnosticLIRGeneratorTool;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.lir.profiling.MoveProfiler;
import org.graalvm.compiler.lir.profiling.MoveType;
import org.graalvm.compiler.options.OptionKey;

public class MoveProfilingPhase
extends PostAllocationOptimizationPhase {
    private static final String MOVE_OPERATIONS = "MoveOperations";

    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        new Analyzer(target, lirGenRes, context.diagnosticLirGenTool).run();
    }

    static class Analyzer {
        private final TargetDescription target;
        private final LIRGenerationResult lirGenRes;
        private final DiagnosticLIRGeneratorTool diagnosticLirGenTool;
        private final LIRInsertionBuffer buffer;
        private String cachedGroupName;
        private final List<String> names;
        private final List<String> groups;
        private final List<Value> increments;

        Analyzer(TargetDescription target, LIRGenerationResult lirGenRes, DiagnosticLIRGeneratorTool diagnosticLirGenTool) {
            this.target = target;
            this.lirGenRes = lirGenRes;
            this.diagnosticLirGenTool = diagnosticLirGenTool;
            this.buffer = new LIRInsertionBuffer();
            this.names = new ArrayList<String>();
            this.groups = new ArrayList<String>();
            this.increments = new ArrayList<Value>();
        }

        public void run() {
            LIR lir = this.lirGenRes.getLIR();
            BlockMap<MoveProfiler.MoveStatistics> collected = MoveProfiler.profile(lir);
            for (AbstractBlockBase block : lir.getControlFlowGraph().getBlocks()) {
                MoveProfiler.MoveStatistics moveStatistics = collected.get(block);
                if (moveStatistics == null) continue;
                this.names.clear();
                this.groups.clear();
                this.increments.clear();
                this.doBlock(block, moveStatistics);
            }
        }

        public void doBlock(AbstractBlockBase<?> block, MoveProfiler.MoveStatistics moveStatistics) {
            for (MoveType type : MoveType.values()) {
                String name = type.toString();
                this.addEntry(name, this.getGroupName(), moveStatistics.get(type));
            }
            this.insertBenchmarkCounter(block);
        }

        protected final void addEntry(String name, String groupName, int count) {
            if (count > 0) {
                this.names.add(name);
                this.groups.add(groupName);
                this.increments.add(new ConstantValue(LIRKind.fromJavaKind(this.target.arch, JavaKind.Int), (Constant)JavaConstant.forInt((int)count)));
            }
        }

        protected final void insertBenchmarkCounter(AbstractBlockBase<?> block) {
            int size = this.names.size();
            if (size > 0) {
                assert (size > 0 && size == this.groups.size() && size == this.increments.size());
                ArrayList<LIRInstruction> instructions = this.lirGenRes.getLIR().getLIRforBlock(block);
                LIRInstruction inst = this.diagnosticLirGenTool.createMultiBenchmarkCounter(this.names.toArray(new String[size]), this.groups.toArray(new String[size]), this.increments.toArray(new Value[size]));
                assert (inst != null);
                this.buffer.init(instructions);
                this.buffer.append(1, inst);
                this.buffer.finish();
            }
        }

        protected final String getGroupName() {
            if (this.cachedGroupName == null) {
                this.cachedGroupName = this.createGroupName();
            }
            return this.cachedGroupName;
        }

        protected String createGroupName() {
            if (Options.LIRDynMoveProfileMethod.getValue(this.lirGenRes.getLIR().getOptions()).booleanValue()) {
                return "\"" + MoveProfilingPhase.MOVE_OPERATIONS + ':' + this.lirGenRes.getCompilationUnitName() + '\"';
            }
            return MoveProfilingPhase.MOVE_OPERATIONS;
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> LIRDynMoveProfileMethod = new OptionKey<Boolean>(false);
    }
}

