/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.profiling;

import java.util.ArrayList;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.BlockMap;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.profiling.MoveType;

public final class MoveProfiler {
    private final LIR lir;
    private final BlockMap<MoveStatistics> blockMap;

    public static BlockMap<MoveStatistics> profile(LIR lir) {
        MoveProfiler profiler = new MoveProfiler(lir);
        profiler.run();
        return profiler.blockMap;
    }

    private MoveProfiler(LIR lir) {
        this.lir = lir;
        this.blockMap = new BlockMap(lir.getControlFlowGraph());
    }

    private void run() {
        for (AbstractBlockBase block : this.lir.getControlFlowGraph().getBlocks()) {
            this.doBlock(block);
        }
    }

    private void doBlock(AbstractBlockBase<?> block) {
        ArrayList<LIRInstruction> instructions = this.lir.getLIRforBlock(block);
        assert (instructions.size() >= 2) : "Malformed block: " + block + ", " + instructions;
        assert (instructions.get(instructions.size() - 1) instanceof StandardOp.BlockEndOp) : "Not a BlockEndOp: " + instructions.get(instructions.size() - 1);
        assert (!(instructions.get(instructions.size() - 2) instanceof StandardOp.BlockEndOp)) : "Is a BlockEndOp: " + instructions.get(instructions.size() - 2);
        assert (instructions.get(0) instanceof StandardOp.LabelOp) : "Not a LabelOp: " + instructions.get(0);
        assert (!(instructions.get(1) instanceof StandardOp.LabelOp)) : "Is a LabelOp: " + instructions.get(1);
        MoveStatistics stats = null;
        for (LIRInstruction inst : instructions) {
            if (!StandardOp.MoveOp.isMoveOp(inst)) continue;
            if (stats == null) {
                stats = new MoveStatistics();
                this.blockMap.put(block, stats);
            }
            stats.add(MoveType.get(inst));
        }
    }

    static class MoveStatistics {
        private final int[] cnt = new int[MoveType.values().length];

        MoveStatistics() {
        }

        public void add(MoveType moveType) {
            int n = moveType.ordinal();
            this.cnt[n] = this.cnt[n] + 1;
        }

        public int get(MoveType moveType) {
            return this.cnt[moveType.ordinal()];
        }

        public void add(MoveType moveType, int value) {
            int n = moveType.ordinal();
            this.cnt[n] = this.cnt[n] + value;
        }
    }
}

