/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CodeUtil;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64ASIMDAssembler;
import org.graalvm.compiler.asm.aarch64.AArch64Address;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.StubPort;
import org.graalvm.compiler.lir.StubPorts;
import org.graalvm.compiler.lir.aarch64.AArch64LIRInstruction;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@StubPorts(value={@StubPort(path="src/hotspot/cpu/aarch64/stubGenerator_aarch64.cpp", lineStart=2594, lineEnd=2625, commit="61e072d11c8e0cb5879bb733ed1fdd2144326bfd", sha1="e2f617436bf0437ef9838d8a599d8833b592b8e7"), @StubPort(path="src/hotspot/cpu/aarch64/macroAssembler_aarch64_aes.cpp", lineStart=34, lineEnd=110, commit="61e072d11c8e0cb5879bb733ed1fdd2144326bfd", sha1="4d2014f2d3c779868b888ff698909e44503939dc")})
public final class AArch64AESDecryptOp
extends AArch64LIRInstruction {
    public static final LIRInstructionClass<AArch64AESDecryptOp> TYPE = LIRInstructionClass.create(AArch64AESDecryptOp.class);
    private final int lengthOffset;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value fromValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value toValue;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value keyValue;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value[] temps;

    public AArch64AESDecryptOp(Value fromValue, Value toValue, Value keyValue, int lengthOffset) {
        super((LIRInstructionClass<? extends AArch64LIRInstruction>)TYPE);
        this.fromValue = fromValue;
        this.toValue = toValue;
        this.keyValue = keyValue;
        this.lengthOffset = lengthOffset;
        this.temps = new Value[]{AArch64.v0.asValue(), AArch64.v1.asValue(), AArch64.v2.asValue(), AArch64.v3.asValue(), AArch64.v4.asValue(), AArch64.v5.asValue()};
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        assert (this.fromValue.getPlatformKind().equals(AArch64Kind.QWORD)) : this.fromValue;
        assert (this.toValue.getPlatformKind().equals(AArch64Kind.QWORD)) : this.toValue;
        assert (this.keyValue.getPlatformKind().equals(AArch64Kind.QWORD)) : this.keyValue;
        Register from = ValueUtil.asRegister((Value)this.fromValue);
        Register to = ValueUtil.asRegister((Value)this.toValue);
        Register key = ValueUtil.asRegister((Value)this.keyValue);
        try (AArch64MacroAssembler.ScratchRegister sr = masm.getScratchRegister();){
            Register keylen = sr.getRegister();
            masm.ldr(32, keylen, AArch64Address.createImmediateAddress(32, AArch64Address.AddressingMode.IMMEDIATE_SIGNED_UNSCALED, key, this.lengthOffset));
            AArch64AESDecryptOp.aesecbDecrypt(masm, from, to, key, keylen);
        }
    }

    private static void aesecbDecrypt(AArch64MacroAssembler masm, Register from, Register to, Register key, Register keylen) {
        Label labelDoLast = new Label();
        masm.fldr(128, AArch64.v0, AArch64Address.createBaseRegisterOnlyAddress(128, from));
        masm.fldr(128, AArch64.v5, AArch64Address.createImmediateAddress(128, AArch64Address.AddressingMode.IMMEDIATE_POST_INDEXED, key, 16));
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v5, AArch64.v5);
        AArch64Address ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v3, AArch64.v3);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v4, AArch64.v4);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v3);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v4);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_4R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 64);
        masm.neon.ld1MultipleVVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, AArch64.v3, AArch64.v4, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v3, AArch64.v3);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v4, AArch64.v4);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v3);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v4);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.compare(32, keylen, 44);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelDoLast);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.compare(32, keylen, 52);
        masm.branchConditionally(AArch64Assembler.ConditionFlag.EQ, labelDoLast);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        ld1Addr = AArch64Address.createStructureImmediatePostIndexAddress(AArch64ASIMDAssembler.ASIMDInstruction.LD1_MULTIPLE_2R, AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, key, 32);
        masm.neon.ld1MultipleVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v2, ld1Addr);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v1, AArch64.v1);
        masm.neon.rev32VV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64ASIMDAssembler.ElementSize.Byte, AArch64.v2, AArch64.v2);
        masm.bind(labelDoLast);
        masm.neon.aesd(AArch64.v0, AArch64.v1);
        masm.neon.aesimc(AArch64.v0, AArch64.v0);
        masm.neon.aesd(AArch64.v0, AArch64.v2);
        masm.neon.eorVVV(AArch64ASIMDAssembler.ASIMDSize.FullReg, AArch64.v0, AArch64.v0, AArch64.v5);
        masm.fstr(128, AArch64.v0, AArch64Address.createBaseRegisterOnlyAddress(128, to));
        masm.sub(64, key, key, keylen, AArch64Assembler.ShiftType.LSL, CodeUtil.log2((int)JavaKind.Int.getByteCount()));
    }
}

