/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.lir;

import java.util.ArrayList;
import jdk.vm.ci.code.TargetDescription;
import org.graalvm.compiler.core.common.GraalOptions;
import org.graalvm.compiler.core.common.cfg.AbstractBlockBase;
import org.graalvm.compiler.core.common.cfg.CodeEmissionOrder;
import org.graalvm.compiler.lir.LIR;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.StandardOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.phases.PostAllocationOptimizationPhase;
import org.graalvm.compiler.options.OptionKey;

public final class ComputeCodeEmissionOrder
extends PostAllocationOptimizationPhase {
    @Override
    protected void run(TargetDescription target, LIRGenerationResult lirGenRes, PostAllocationOptimizationPhase.PostAllocationOptimizationContext context) {
        LIR lir = lirGenRes.getLIR();
        AbstractBlockBase<?>[] layout = context.blockOrder.computeCodeEmittingOrder(lir.getOptions(), CodeEmissionOrder.ComputationTime.AFTER_CONTROL_FLOW_OPTIMIZATIONS);
        assert (LIR.verifyBlocks(lir, layout)) : "Block layout is not correct";
        lir.setCodeEmittingOrder(layout);
        for (AbstractBlockBase<?> block : layout) {
            if (!block.isAligned()) continue;
            ArrayList<LIRInstruction> instructions = lir.getLIRforBlock(block);
            assert (instructions.get(0) instanceof StandardOp.LabelOp) : "first instruction must always be a label";
            StandardOp.LabelOp label = (StandardOp.LabelOp)instructions.get(0);
            label.setAlignment(GraalOptions.LoopHeaderAlignment.getValue(lir.getOptions()));
        }
    }

    public static class Options {
        public static final OptionKey<Boolean> EarlyCodeEmissionOrder = new OptionKey<Boolean>(false);
    }
}

