/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import java.util.Collections;
import java.util.List;
import jdk.vm.ci.meta.Assumptions;
import jdk.vm.ci.meta.ResolvedJavaField;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.type.AbstractPointerStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.core.common.type.StampPair;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.NodeClass;
import org.graalvm.compiler.hotspot.meta.HotSpotLoweringProvider;
import org.graalvm.compiler.hotspot.replacements.ObjectCloneSnippets;
import org.graalvm.compiler.nodeinfo.NodeInfo;
import org.graalvm.compiler.nodes.InvokeNode;
import org.graalvm.compiler.nodes.NodeView;
import org.graalvm.compiler.nodes.ParameterNode;
import org.graalvm.compiler.nodes.ReturnNode;
import org.graalvm.compiler.nodes.StructuredGraph;
import org.graalvm.compiler.nodes.ValueNode;
import org.graalvm.compiler.nodes.java.LoadFieldNode;
import org.graalvm.compiler.nodes.spi.Lowerable;
import org.graalvm.compiler.nodes.spi.LoweringTool;
import org.graalvm.compiler.nodes.spi.Replacements;
import org.graalvm.compiler.nodes.type.StampTool;
import org.graalvm.compiler.nodes.virtual.AllocatedObjectNode;
import org.graalvm.compiler.nodes.virtual.CommitAllocationNode;
import org.graalvm.compiler.nodes.virtual.VirtualInstanceNode;
import org.graalvm.compiler.nodes.virtual.VirtualObjectNode;
import org.graalvm.compiler.phases.common.inlining.InliningUtil;
import org.graalvm.compiler.replacements.SnippetTemplate;
import org.graalvm.compiler.replacements.nodes.BasicObjectCloneNode;
import org.graalvm.compiler.replacements.nodes.MacroInvokable;
import org.graalvm.compiler.replacements.nodes.MacroNode;

@NodeInfo
public final class ObjectCloneNode
extends BasicObjectCloneNode {
    public static final NodeClass<ObjectCloneNode> TYPE = NodeClass.create(ObjectCloneNode.class);

    public ObjectCloneNode(MacroNode.MacroParams p) {
        super(TYPE, p);
    }

    @Override
    public Stamp computeStamp(ValueNode object) {
        if (this.getConcreteType(object.stamp(NodeView.DEFAULT)) != null) {
            return AbstractPointerStamp.pointerNonNull(object.stamp(NodeView.DEFAULT));
        }
        return AbstractPointerStamp.pointerMaybeNull(this.returnStamp.getTrustedStamp());
    }

    @Override
    public void lower(LoweringTool tool) {
        StructuredGraph replacementGraph = this.getLoweredSnippetGraph(tool);
        if (replacementGraph != null) {
            ValueNode nonNullReceiver;
            InvokeNode invoke = this.createInvoke(false);
            this.graph().replaceFixedWithFixed(this, invoke);
            if (!this.getTargetMethod().isStatic() && (nonNullReceiver = InliningUtil.nonNullReceiver(invoke)) instanceof Lowerable) {
                ((Lowerable)((Object)nonNullReceiver)).lower(tool);
            }
            InliningUtil.inline(invoke, replacementGraph, false, this.getTargetMethod(), "Replace with graph.", "LoweringPhase");
            replacementGraph.getDebug().dump(4, (Object)this.asNode().graph(), "After inlining replacement %s", replacementGraph);
        } else {
            super.lower(tool);
        }
    }

    private StructuredGraph getLoweredSnippetGraph(LoweringTool tool) {
        ResolvedJavaType type = StampTool.typeOrNull(this.getObject());
        if (type != null) {
            if (type.isArray()) {
                HotSpotLoweringProvider lowerer = (HotSpotLoweringProvider)tool.getLowerer();
                ObjectCloneSnippets.Templates objectCloneSnippets = lowerer.getObjectCloneSnippets();
                SnippetTemplate.SnippetInfo info = objectCloneSnippets.arrayCloneMethods.get(type.getComponentType().getJavaKind());
                if (info != null) {
                    ResolvedJavaMethod snippetMethod = info.getMethod();
                    Replacements replacements = tool.getReplacements();
                    StructuredGraph snippetGraph = null;
                    DebugContext debug = this.getDebug();
                    try (DebugContext.Scope s = debug.scope((Object)"ArrayCloneSnippet", snippetMethod);){
                        snippetGraph = replacements.getSnippet(snippetMethod, null, null, null, this.graph().trackNodeSourcePosition(), this.getNodeSourcePosition(), debug.getOptions());
                    }
                    catch (Throwable e) {
                        throw debug.handle(e);
                    }
                    assert (snippetGraph != null) : "ObjectCloneSnippets should be installed";
                    assert (this.getConcreteType(this.stamp(NodeView.DEFAULT)) != null);
                    return MacroInvokable.lowerReplacement(this.graph(), (StructuredGraph)snippetGraph.copy(this.getDebug()), tool);
                }
                GraalError.shouldNotReachHere("unhandled array type " + type.getComponentType().getJavaKind());
            } else {
                Assumptions assumptions = this.graph().getAssumptions();
                type = this.getConcreteType(this.getObject().stamp(NodeView.DEFAULT));
                if (type != null) {
                    StructuredGraph newGraph = new StructuredGraph.Builder(this.graph().getOptions(), this.graph().getDebug(), StructuredGraph.AllowAssumptions.ifNonNull(assumptions)).name("<clone>").build();
                    ParameterNode param = newGraph.addWithoutUnique(new ParameterNode(0, StampPair.createSingle(this.getObject().stamp(NodeView.DEFAULT))));
                    CommitAllocationNode commit = newGraph.add(new CommitAllocationNode());
                    newGraph.addAfterFixed(newGraph.start(), commit);
                    VirtualObjectNode virtualObj = newGraph.add(new VirtualInstanceNode(type, true));
                    virtualObj.setObjectId(0);
                    AllocatedObjectNode newObj = newGraph.addWithoutUnique(new AllocatedObjectNode(virtualObj));
                    commit.getVirtualObjects().add(virtualObj);
                    newObj.setCommit(commit);
                    ReturnNode returnNode = newGraph.add(new ReturnNode(newObj));
                    newGraph.addAfterFixed(commit, returnNode);
                    List<ValueNode> commitValues = commit.getValues();
                    for (ResolvedJavaField field : type.getInstanceFields(true)) {
                        LoadFieldNode load = newGraph.add(LoadFieldNode.create(newGraph.getAssumptions(), param, field));
                        newGraph.addBeforeFixed(commit, load);
                        commitValues.add(load);
                    }
                    commit.addLocks(Collections.emptyList());
                    commit.getEnsureVirtual().add(false);
                    assert (commit.verify());
                    assert (this.getConcreteType(this.stamp(NodeView.DEFAULT)) != null);
                    return MacroInvokable.lowerReplacement(this.graph(), newGraph, tool);
                }
            }
        }
        assert (this.getConcreteType(this.stamp(NodeView.DEFAULT)) == null);
        return null;
    }
}

