/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.replacements;

import jdk.vm.ci.meta.JavaKind;
import org.graalvm.compiler.core.common.spi.ForeignCallDescriptor;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallDescriptor;
import org.graalvm.compiler.hotspot.meta.HotSpotForeignCallsProviderImpl;
import org.graalvm.compiler.nodes.extended.ForeignCallNode;
import org.graalvm.compiler.replacements.nodes.CStringConstant;
import org.graalvm.compiler.word.Word;

public final class Log {
    public static final HotSpotForeignCallDescriptor LOG_PRIMITIVE = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "logPrimitive", Void.TYPE, Integer.TYPE, Long.TYPE, Boolean.TYPE);
    public static final HotSpotForeignCallDescriptor LOG_OBJECT = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "logObject", Void.TYPE, Object.class, Boolean.TYPE, Boolean.TYPE);
    public static final HotSpotForeignCallDescriptor LOG_PRINTF = new HotSpotForeignCallDescriptor(HotSpotForeignCallDescriptor.Transition.LEAF, HotSpotForeignCallDescriptor.Reexecutability.REEXECUTABLE, HotSpotForeignCallsProviderImpl.NO_LOCATIONS, "logPrintf", Void.TYPE, Word.class, Long.TYPE, Long.TYPE, Long.TYPE);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void log(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Object var1, boolean var2, boolean var3);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void log(@Node.ConstantNodeParameter ForeignCallDescriptor var0, int var1, long var2, boolean var4);

    @Node.NodeIntrinsic(value=ForeignCallNode.class)
    private static native void printf(@Node.ConstantNodeParameter ForeignCallDescriptor var0, Word var1, long var2, long var4, long var6);

    public static void print(boolean value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Boolean.getTypeChar(), value ? 1L : 0L, false);
    }

    public static void print(byte value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Byte.getTypeChar(), value, false);
    }

    public static void print(char value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Char.getTypeChar(), value, false);
    }

    public static void print(short value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Short.getTypeChar(), value, false);
    }

    public static void print(int value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Int.getTypeChar(), value, false);
    }

    public static void print(long value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Long.getTypeChar(), value, false);
    }

    public static void printf(String format, long value) {
        Log.printf(LOG_PRINTF, CStringConstant.cstring(format), value, 0L, 0L);
    }

    public static void printf(String format, long v1, long v2) {
        Log.printf(LOG_PRINTF, CStringConstant.cstring(format), v1, v2, 0L);
    }

    public static void printf(String format, long v1, long v2, long v3) {
        Log.printf(LOG_PRINTF, CStringConstant.cstring(format), v1, v2, v3);
    }

    public static void printf(Word format, long value) {
        Log.printf(LOG_PRINTF, format, value, 0L, 0L);
    }

    public static void printf(Word format, long v1, long v2) {
        Log.printf(LOG_PRINTF, format, v1, v2, 0L);
    }

    public static void printf(Word format, long v1, long v2, long v3) {
        Log.printf(LOG_PRINTF, format, v1, v2, v3);
    }

    public static void print(float value) {
        if (Float.isNaN(value)) {
            Log.print("NaN");
        } else if (value == Float.POSITIVE_INFINITY) {
            Log.print("Infinity");
        } else if (value == Float.NEGATIVE_INFINITY) {
            Log.print("-Infinity");
        } else {
            Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Float.getTypeChar(), Float.floatToRawIntBits(value), false);
        }
    }

    public static void print(double value) {
        if (Double.isNaN(value)) {
            Log.print("NaN");
        } else if (value == Double.POSITIVE_INFINITY) {
            Log.print("Infinity");
        } else if (value == Double.NEGATIVE_INFINITY) {
            Log.print("-Infinity");
        } else {
            Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Double.getTypeChar(), Double.doubleToRawLongBits(value), false);
        }
    }

    public static void print(Word value) {
        Log.printf(LOG_PRINTF, value, 0L, 0L, 0L);
    }

    public static void print(String value) {
        Log.log((ForeignCallDescriptor)LOG_OBJECT, value, true, false);
    }

    public static void printObject(Object o) {
        Log.log((ForeignCallDescriptor)LOG_OBJECT, o, false, false);
    }

    public static void println(boolean value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Boolean.getTypeChar(), value ? 1L : 0L, true);
    }

    public static void println(byte value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Byte.getTypeChar(), value, true);
    }

    public static void println(char value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Char.getTypeChar(), value, true);
    }

    public static void println(short value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Short.getTypeChar(), value, true);
    }

    public static void println(int value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Int.getTypeChar(), value, true);
    }

    public static void println(long value) {
        Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Long.getTypeChar(), value, true);
    }

    public static void println(float value) {
        if (Float.isNaN(value)) {
            Log.println("NaN");
        } else if (value == Float.POSITIVE_INFINITY) {
            Log.println("Infinity");
        } else if (value == Float.NEGATIVE_INFINITY) {
            Log.println("-Infinity");
        } else {
            Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Float.getTypeChar(), Float.floatToRawIntBits(value), true);
        }
    }

    public static void println(double value) {
        if (Double.isNaN(value)) {
            Log.println("NaN");
        } else if (value == Double.POSITIVE_INFINITY) {
            Log.println("Infinity");
        } else if (value == Double.NEGATIVE_INFINITY) {
            Log.println("-Infinity");
        } else {
            Log.log((ForeignCallDescriptor)LOG_PRIMITIVE, JavaKind.Double.getTypeChar(), Double.doubleToRawLongBits(value), true);
        }
    }

    public static void println(String value) {
        Log.log((ForeignCallDescriptor)LOG_OBJECT, value, true, true);
    }

    public static void printlnObject(Object o) {
        Log.log((ForeignCallDescriptor)LOG_OBJECT, o, false, true);
    }

    public static void println() {
        Log.println("");
    }
}

