/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.nodes.type;

import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotMemoryAccessProvider;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.MemoryAccessProvider;
import jdk.vm.ci.meta.ResolvedJavaType;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.type.AbstractObjectStamp;
import org.graalvm.compiler.core.common.type.ObjectStamp;
import org.graalvm.compiler.core.common.type.Stamp;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.nodes.type.KlassPointerStamp;
import org.graalvm.compiler.nodes.CompressionNode;
import org.graalvm.compiler.nodes.type.NarrowOopStamp;

public final class HotSpotNarrowOopStamp
extends NarrowOopStamp {
    private HotSpotNarrowOopStamp(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull, boolean alwaysArray, CompressEncoding encoding) {
        super(type, exactType, nonNull, alwaysNull, alwaysArray, encoding);
    }

    @Override
    protected AbstractObjectStamp copyWith(ResolvedJavaType type, boolean exactType, boolean nonNull, boolean alwaysNull, boolean alwaysArray) {
        return new HotSpotNarrowOopStamp(type, exactType, nonNull, alwaysNull, alwaysArray, this.getEncoding());
    }

    public static Stamp compressed(AbstractObjectStamp stamp, CompressEncoding encoding) {
        return new HotSpotNarrowOopStamp(stamp.type(), stamp.isExactType(), stamp.nonNull(), stamp.alwaysNull(), stamp.isAlwaysArray(), encoding);
    }

    @Override
    public Constant readConstant(MemoryAccessProvider provider, Constant base, long displacement) {
        try {
            HotSpotMemoryAccessProvider hsProvider = (HotSpotMemoryAccessProvider)provider;
            return hsProvider.readNarrowOopConstant(base, displacement);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    @Override
    public JavaConstant nullConstant() {
        return HotSpotCompressedNullConstant.COMPRESSED_NULL;
    }

    @Override
    public boolean isCompatible(Constant other) {
        if (other instanceof HotSpotObjectConstant) {
            return ((HotSpotObjectConstant)other).isCompressed();
        }
        return true;
    }

    public static Stamp mkStamp(CompressionNode.CompressionOp op, Stamp input, CompressEncoding encoding) {
        switch (op) {
            case Compress: {
                if (input instanceof ObjectStamp) {
                    return HotSpotNarrowOopStamp.compressed((ObjectStamp)input, encoding);
                }
                if (!(input instanceof KlassPointerStamp)) break;
                return ((KlassPointerStamp)input).compressed(encoding);
            }
            case Uncompress: {
                if (input instanceof NarrowOopStamp) {
                    assert (encoding.equals(((NarrowOopStamp)input).getEncoding()));
                    return ((NarrowOopStamp)input).uncompressed();
                }
                if (!(input instanceof KlassPointerStamp)) break;
                assert (encoding.equals(((KlassPointerStamp)input).getEncoding()));
                return ((KlassPointerStamp)input).uncompressed();
            }
        }
        throw GraalError.shouldNotReachHere(String.format("Unexpected input stamp %s", input));
    }
}

