/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.amd64;

import jdk.vm.ci.amd64.AMD64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.amd64.AMD64Address;
import org.graalvm.compiler.asm.amd64.AMD64MacroAssembler;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotHostBackend;
import org.graalvm.compiler.hotspot.amd64.AMD64HotSpotEpilogueBlockEndOp;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.amd64.AMD64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="DEOPT_WITH_EXCEPTION_IN_CALLER")
final class AMD64HotSpotDeoptimizeWithExceptionCallerOp
extends AMD64HotSpotEpilogueBlockEndOp {
    public static final LIRInstructionClass<AMD64HotSpotDeoptimizeWithExceptionCallerOp> TYPE = LIRInstructionClass.create(AMD64HotSpotDeoptimizeWithExceptionCallerOp.class);
    private final GraalHotSpotVMConfig config;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.REG})
    private Value exception;
    @LIRInstruction.Temp(value={LIRInstruction.OperandFlag.REG})
    private Value temp;

    protected AMD64HotSpotDeoptimizeWithExceptionCallerOp(GraalHotSpotVMConfig config, Value exception) {
        super((LIRInstructionClass<? extends AMD64HotSpotEpilogueBlockEndOp>)TYPE);
        this.config = config;
        this.exception = exception;
        this.temp = AMD64.rax.asValue();
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AMD64MacroAssembler masm) {
        Register stackPointer = crb.frameMap.getRegisterConfig().getFrameRegister();
        Register exc = ValueUtil.asRegister((Value)this.exception);
        this.leaveFrameAndRestoreRbp(crb, masm);
        masm.movq(new AMD64Address(AMD64.r15, this.config.threadExceptionOopOffset), exc);
        Register returnPC = ValueUtil.asRegister((Value)this.temp);
        masm.movq(returnPC, new AMD64Address(stackPointer, 0));
        masm.movq(new AMD64Address(AMD64.r15, this.config.threadExceptionPcOffset), returnPC);
        masm.addq(stackPointer, crb.target.arch.getReturnAddressSize());
        AMD64Call.directJmp(crb, masm, crb.foreignCalls.lookupForeignCall(HotSpotHostBackend.DEOPT_BLOB_UNPACK_WITH_EXCEPTION_IN_TLS), null);
    }
}

