/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.InvokeTarget;
import jdk.vm.ci.meta.ResolvedJavaMethod;
import jdk.vm.ci.meta.Value;
import org.graalvm.compiler.asm.aarch64.AArch64MacroAssembler;
import org.graalvm.compiler.hotspot.HotSpotMarkId;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.Opcode;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.asm.CompilationResultBuilder;

@Opcode(value="CALL_INDIRECT")
final class AArch64IndirectCallOp
extends AArch64Call.IndirectCallOp {
    public static final LIRInstructionClass<AArch64IndirectCallOp> TYPE = LIRInstructionClass.create(AArch64IndirectCallOp.class);
    public static final Register METHOD = AArch64.r12;
    @LIRInstruction.Use(value={LIRInstruction.OperandFlag.REG})
    private Value metaspaceMethod;

    AArch64IndirectCallOp(ResolvedJavaMethod callTarget, Value result, Value[] parameters, Value[] temps, Value metaspaceMethod, Value targetAddress, LIRFrameState state) {
        super(TYPE, callTarget, result, parameters, temps, targetAddress, state);
        this.metaspaceMethod = metaspaceMethod;
    }

    @Override
    public void emitCode(CompilationResultBuilder crb, AArch64MacroAssembler masm) {
        Register callReg = ValueUtil.asRegister((Value)this.targetAddress);
        assert (!callReg.equals((Object)METHOD));
        crb.recordMark(AArch64Call.indirectCall(crb, masm, callReg, (InvokeTarget)this.callTarget, this.state), HotSpotMarkId.INLINE_INVOKE);
    }

    @Override
    public void verify() {
        super.verify();
        assert (ValueUtil.asRegister((Value)this.metaspaceMethod).equals((Object)METHOD));
    }
}

