/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot.aarch64;

import java.util.Arrays;
import java.util.EnumSet;
import java.util.function.Function;
import jdk.vm.ci.aarch64.AArch64;
import jdk.vm.ci.aarch64.AArch64Kind;
import jdk.vm.ci.code.CallingConvention;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.RegisterValue;
import jdk.vm.ci.hotspot.HotSpotCompressedNullConstant;
import jdk.vm.ci.hotspot.HotSpotObjectConstant;
import jdk.vm.ci.meta.AllocatableValue;
import jdk.vm.ci.meta.Constant;
import jdk.vm.ci.meta.DeoptimizationAction;
import jdk.vm.ci.meta.DeoptimizationReason;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.PlatformKind;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.meta.Value;
import jdk.vm.ci.meta.ValueKind;
import org.graalvm.compiler.asm.Label;
import org.graalvm.compiler.asm.aarch64.AArch64Assembler;
import org.graalvm.compiler.core.aarch64.AArch64ArithmeticLIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRGenerator;
import org.graalvm.compiler.core.aarch64.AArch64LIRKindTool;
import org.graalvm.compiler.core.common.CompressEncoding;
import org.graalvm.compiler.core.common.LIRKind;
import org.graalvm.compiler.core.common.calc.Condition;
import org.graalvm.compiler.core.common.spi.ForeignCallLinkage;
import org.graalvm.compiler.core.common.spi.LIRKindTool;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.HotSpotBackend;
import org.graalvm.compiler.hotspot.HotSpotDebugInfoBuilder;
import org.graalvm.compiler.hotspot.HotSpotForeignCallLinkage;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerationResult;
import org.graalvm.compiler.hotspot.HotSpotLIRGenerator;
import org.graalvm.compiler.hotspot.HotSpotLockStack;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotCRuntimeCallEpilogueOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotCRuntimeCallPrologueOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotCounterOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotDeoptimizeCallerOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotDeoptimizeOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotDeoptimizeWithExceptionCallerOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotMove;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotMoveFactory;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotReturnOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotStrategySwitchOp;
import org.graalvm.compiler.hotspot.aarch64.AArch64HotSpotUnwindOp;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.hotspot.meta.HotSpotProviders;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.hotspot.stubs.Stub;
import org.graalvm.compiler.lir.LIRFrameState;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRValueUtil;
import org.graalvm.compiler.lir.LabelRef;
import org.graalvm.compiler.lir.SwitchStrategy;
import org.graalvm.compiler.lir.Variable;
import org.graalvm.compiler.lir.VirtualStackSlot;
import org.graalvm.compiler.lir.aarch64.AArch64AddressValue;
import org.graalvm.compiler.lir.aarch64.AArch64CCall;
import org.graalvm.compiler.lir.aarch64.AArch64Call;
import org.graalvm.compiler.lir.aarch64.AArch64ControlFlow;
import org.graalvm.compiler.lir.aarch64.AArch64FrameMapBuilder;
import org.graalvm.compiler.lir.aarch64.AArch64Move;
import org.graalvm.compiler.lir.aarch64.AArch64PrefetchOp;
import org.graalvm.compiler.lir.aarch64.AArch64RestoreRegistersOp;
import org.graalvm.compiler.lir.aarch64.AArch64SaveRegistersOp;
import org.graalvm.compiler.lir.gen.LIRGenerationResult;
import org.graalvm.compiler.lir.gen.MoveFactory;

public class AArch64HotSpotLIRGenerator
extends AArch64LIRGenerator
implements HotSpotLIRGenerator {
    final GraalHotSpotVMConfig config;
    private HotSpotDebugInfoBuilder debugInfoBuilder;
    private LIRFrameState currentRuntimeCallInfo;
    private Label label;

    protected AArch64HotSpotLIRGenerator(HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        this(new AArch64LIRKindTool(), new AArch64ArithmeticLIRGenerator(null), new AArch64HotSpotMoveFactory(), providers, config, lirGenRes);
    }

    protected AArch64HotSpotLIRGenerator(LIRKindTool lirKindTool, AArch64ArithmeticLIRGenerator arithmeticLIRGen, MoveFactory moveFactory, HotSpotProviders providers, GraalHotSpotVMConfig config, LIRGenerationResult lirGenRes) {
        super(lirKindTool, arithmeticLIRGen, moveFactory, providers, lirGenRes);
        this.config = config;
    }

    @Override
    public HotSpotProviders getProviders() {
        return (HotSpotProviders)super.getProviders();
    }

    @Override
    public boolean needOnlyOopMaps() {
        return this.getResult().getStub() != null;
    }

    @Override
    protected Value getCompareValueForConstantPointer(Value v) {
        if (LIRValueUtil.isConstantValue(v)) {
            Constant c = LIRValueUtil.asConstant(v);
            if (HotSpotCompressedNullConstant.COMPRESSED_NULL.equals(c)) {
                return AArch64.zr.asValue((ValueKind)LIRKind.value((PlatformKind)AArch64Kind.DWORD));
            }
            if (c instanceof HotSpotObjectConstant) {
                return this.asAllocatable(v);
            }
        }
        return super.getCompareValueForConstantPointer(v);
    }

    @Override
    protected void emitForeignCallOp(ForeignCallLinkage linkage, Value targetAddress, Value result, Value[] arguments, Value[] temps, LIRFrameState info) {
        this.currentRuntimeCallInfo = info;
        if (AArch64Call.isNearCall(linkage)) {
            this.append(new AArch64Call.DirectNearForeignCallOp(linkage, result, arguments, temps, info, this.label));
        } else {
            this.append(new AArch64Call.DirectFarForeignCallOp(linkage, result, arguments, temps, info, this.label));
        }
    }

    @Override
    public void emitTailcall(Value[] args, Value address) {
        throw GraalError.unimplemented();
    }

    @Override
    public void emitCCall(long address, CallingConvention nativeCallingConvention, Value[] args) {
        Value[] argLocations = new Value[args.length];
        this.getResult().getFrameMapBuilder().callsMethod(nativeCallingConvention);
        for (int i = 0; i < args.length; ++i) {
            Value arg = args[i];
            AllocatableValue loc = nativeCallingConvention.getArgument(i);
            this.emitMove(loc, arg);
            argLocations[i] = loc;
        }
        AllocatableValue ptr = this.emitLoadConstant(LIRKind.value((PlatformKind)AArch64Kind.QWORD), (Constant)JavaConstant.forLong((long)address));
        this.append(new AArch64CCall((Value)nativeCallingConvention.getReturn(), (Value)ptr, argLocations));
    }

    protected AArch64SaveRegistersOp emitSaveRegisters(Register[] savedRegisters, AllocatableValue[] savedRegisterLocations) {
        AArch64SaveRegistersOp save = new AArch64SaveRegistersOp(savedRegisters, savedRegisterLocations);
        this.append(save);
        return save;
    }

    protected VirtualStackSlot allocateSaveRegisterLocation(Register register) {
        PlatformKind kind = this.target().arch.getLargestStorableKind(register.getRegisterCategory());
        if (kind.getVectorLength() > 1) {
            kind = AArch64Kind.DOUBLE;
        }
        return this.getResult().getFrameMapBuilder().allocateSpillSlot(LIRKind.value(kind));
    }

    private AArch64SaveRegistersOp emitSaveAllRegisters(Register[] savedRegisters) {
        AllocatableValue[] savedRegisterLocations = new AllocatableValue[savedRegisters.length];
        for (int i = 0; i < savedRegisters.length; ++i) {
            savedRegisterLocations[i] = this.allocateSaveRegisterLocation(savedRegisters[i]);
        }
        return this.emitSaveRegisters(savedRegisters, savedRegisterLocations);
    }

    protected void emitRestoreRegisters(AArch64SaveRegistersOp save) {
        this.append(new AArch64RestoreRegistersOp((AllocatableValue[])save.getSlots().clone(), save));
    }

    @Override
    public VirtualStackSlot getLockSlot(int lockDepth) {
        return this.getLockStack().makeLockSlot(lockDepth);
    }

    private HotSpotLockStack getLockStack() {
        assert (this.debugInfoBuilder != null && this.debugInfoBuilder.lockStack() != null);
        return this.debugInfoBuilder.lockStack();
    }

    @Override
    public Value emitCompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        assert (inputKind.getPlatformKind() == AArch64Kind.QWORD);
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(LIRKind.compressedReference((PlatformKind)AArch64Kind.DWORD));
            this.append(new AArch64HotSpotMove.CompressPointer(result, this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull));
            return result;
        }
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AArch64Kind.DWORD));
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(LIRKind.value((PlatformKind)AArch64Kind.QWORD), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new AArch64HotSpotMove.CompressPointer(result, this.asAllocatable(pointer), base, encoding, nonNull));
        return result;
    }

    @Override
    public Value emitUncompress(Value pointer, CompressEncoding encoding, boolean nonNull) {
        LIRKind inputKind = (LIRKind)pointer.getValueKind(LIRKind.class);
        assert (inputKind.getPlatformKind() == AArch64Kind.DWORD);
        if (inputKind.isReference(0)) {
            Variable result = this.newVariable(LIRKind.reference((PlatformKind)AArch64Kind.QWORD));
            this.append(new AArch64HotSpotMove.UncompressPointer(result, this.asAllocatable(pointer), (AllocatableValue)this.getProviders().getRegisters().getHeapBaseRegister().asValue(), encoding, nonNull));
            return result;
        }
        Variable result = this.newVariable(LIRKind.value((PlatformKind)AArch64Kind.QWORD));
        AllocatableValue base = Value.ILLEGAL;
        if (encoding.hasBase()) {
            base = this.emitLoadConstant(LIRKind.value((PlatformKind)AArch64Kind.QWORD), (Constant)JavaConstant.forLong((long)encoding.getBase()));
        }
        this.append(new AArch64HotSpotMove.UncompressPointer(result, this.asAllocatable(pointer), base, encoding, nonNull));
        return result;
    }

    @Override
    public void emitNullCheck(Value address, LIRFrameState state) {
        if (address.getValueKind().getPlatformKind() == AArch64Kind.DWORD) {
            CompressEncoding encoding = this.config.getOopEncoding();
            Value uncompressed = this.emitUncompress(address, encoding, false);
            this.append(new AArch64Move.NullCheckOp(this.asAddressValue(uncompressed, -1), state));
        } else {
            super.emitNullCheck(address, state);
        }
    }

    private Value transformBenchmarkCounterIncrement(Value increment) {
        if (LIRValueUtil.isJavaConstant(increment) && AArch64ArithmeticLIRGenerator.isAddSubtractConstant(LIRValueUtil.asJavaConstant(increment))) {
            return increment;
        }
        return this.asAllocatable(increment);
    }

    @Override
    public LIRInstruction createBenchmarkCounter(String name, String group, Value increment) {
        if (BenchmarkCounters.enabled) {
            return new AArch64HotSpotCounterOp(name, group, this.transformBenchmarkCounterIncrement(increment), this.getProviders().getRegisters(), this.config);
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public LIRInstruction createMultiBenchmarkCounter(String[] names, String[] groups, Value[] increments) {
        if (BenchmarkCounters.enabled) {
            Value[] incrementValues = (Value[])Arrays.stream(increments).map(this::transformBenchmarkCounterIncrement).toArray(Value[]::new);
            return new AArch64HotSpotCounterOp(names, groups, incrementValues, this.getProviders().getRegisters(), this.config);
        }
        throw GraalError.shouldNotReachHere("BenchmarkCounters are not enabled!");
    }

    @Override
    public void emitPrefetchAllocate(Value address) {
        this.append(new AArch64PrefetchOp(this.asAddressValue(address, -1), AArch64Assembler.PrefetchMode.PSTL1KEEP));
    }

    @Override
    public void beforeRegisterAllocation() {
        super.beforeRegisterAllocation();
        boolean hasDebugInfo = this.getResult().getLIR().hasDebugInfo();
        if (hasDebugInfo) {
            this.getResult().setDeoptimizationRescueSlot(((AArch64FrameMapBuilder)this.getResult().getFrameMapBuilder()).allocateDeoptimizationRescueSlot());
        }
        this.getResult().setMaxInterpreterFrameSize(this.debugInfoBuilder.maxInterpreterFrameSize());
    }

    @Override
    public Variable emitForeignCall(ForeignCallLinkage linkage, LIRFrameState state, Value ... args) {
        Variable result;
        HotSpotForeignCallLinkage hotspotLinkage = (HotSpotForeignCallLinkage)linkage;
        boolean destroysRegisters = hotspotLinkage.destroysRegisters();
        AArch64SaveRegistersOp save = null;
        Stub stub = this.getStub();
        if (destroysRegisters && stub != null && stub.shouldSaveRegistersAroundCalls()) {
            Register[] savedRegisters = this.getRegisterConfig().getAllocatableRegisters().toArray();
            save = this.emitSaveAllRegisters(savedRegisters);
        }
        LIRFrameState debugInfo = null;
        if (hotspotLinkage.needsDebugInfo()) {
            debugInfo = state;
            assert (debugInfo != null || this.getStub() != null);
        }
        if (destroysRegisters || hotspotLinkage.needsJavaFrameAnchor()) {
            HotSpotRegistersProvider registers = this.getProviders().getRegisters();
            Register thread = registers.getThreadRegister();
            Variable scratch = this.newVariable(LIRKind.value(this.target().arch.getWordKind()));
            this.label = new Label();
            this.append(new AArch64HotSpotCRuntimeCallPrologueOp(this.config.threadLastJavaSpOffset(), this.config.threadLastJavaPcOffset(), thread, scratch, this.label));
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
            this.append(new AArch64HotSpotCRuntimeCallEpilogueOp(this.config.threadLastJavaSpOffset(), this.config.threadLastJavaPcOffset(), thread, this.label));
            this.label = null;
        } else {
            result = super.emitForeignCall(hotspotLinkage, debugInfo, args);
        }
        if (save != null) {
            HotSpotLIRGenerationResult generationResult = this.getResult();
            LIRFrameState key = this.currentRuntimeCallInfo;
            if (key == null) {
                key = LIRFrameState.NO_CALLEE_SAVE_INFO;
            }
            assert (!generationResult.getCalleeSaveInfo().containsKey((Object)key));
            generationResult.getCalleeSaveInfo().put((Object)key, (Object)save);
            this.emitRestoreRegisters(save);
        }
        return result;
    }

    @Override
    public void emitDeoptimizeCaller(DeoptimizationAction action, DeoptimizationReason reason) {
        Value actionAndReason = this.emitJavaConstant(this.getMetaAccess().encodeDeoptActionAndReason(action, reason, 0));
        Value speculation = this.emitJavaConstant(this.getMetaAccess().encodeSpeculation(SpeculationLog.NO_SPECULATION));
        this.moveDeoptValuesToThread(actionAndReason, speculation);
        this.append(new AArch64HotSpotDeoptimizeCallerOp(this.config));
    }

    @Override
    public void emitDeoptimizeWithExceptionInCaller(Value exception) {
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new AArch64HotSpotDeoptimizeWithExceptionCallerOp(this.config, exception, thread));
    }

    @Override
    public void emitDeoptimize(Value actionAndReason, Value failedSpeculation, LIRFrameState state) {
        this.moveDeoptValuesToThread(actionAndReason, failedSpeculation);
        this.append(new AArch64HotSpotDeoptimizeOp(state));
    }

    private void moveDeoptValuesToThread(Value actionAndReason, Value speculation) {
        this.moveValueToThread(actionAndReason, this.config.pendingDeoptimizationOffset);
        this.moveValueToThread(speculation, this.config.pendingFailedSpeculationOffset);
    }

    private void moveValueToThread(Value value, int offset) {
        LIRKind wordKind = LIRKind.value(this.target().arch.getWordKind());
        int bitMemoryTransferSize = value.getValueKind().getPlatformKind().getSizeInBytes() * 8;
        RegisterValue thread = this.getProviders().getRegisters().getThreadRegister().asValue((ValueKind)wordKind);
        AArch64AddressValue address = AArch64AddressValue.makeAddress(wordKind, bitMemoryTransferSize, (AllocatableValue)thread, offset);
        this.append(new AArch64Move.StoreOp((AArch64Kind)value.getPlatformKind(), address, this.asAllocatable(value), null));
    }

    @Override
    public void emitUnwind(Value exception) {
        ForeignCallLinkage linkage = this.getForeignCalls().lookupForeignCall(HotSpotBackend.UNWIND_EXCEPTION_TO_CALLER);
        CallingConvention outgoingCc = linkage.getOutgoingCallingConvention();
        assert (outgoingCc.getArgumentCount() == 2);
        RegisterValue exceptionParameter = (RegisterValue)outgoingCc.getArgument(0);
        this.emitMove((AllocatableValue)exceptionParameter, exception);
        this.append(new AArch64HotSpotUnwindOp(this.config, exceptionParameter));
    }

    @Override
    public void emitReturn(JavaKind kind, Value input) {
        AllocatableValue operand = Value.ILLEGAL;
        if (input != null) {
            operand = this.resultOperandFor(kind, input.getValueKind());
            this.emitMove(operand, input);
        }
        Register thread = this.getProviders().getRegisters().getThreadRegister();
        this.append(new AArch64HotSpotReturnOp((Value)operand, this.getStub() != null, this.config, thread, this.getResult().requiresReservedStackAccessCheck()));
    }

    public Stub getStub() {
        return this.getResult().getStub();
    }

    @Override
    public HotSpotLIRGenerationResult getResult() {
        return (HotSpotLIRGenerationResult)super.getResult();
    }

    @Override
    protected AArch64ControlFlow.StrategySwitchOp createStrategySwitchOp(SwitchStrategy strategy, LabelRef[] keyTargets, LabelRef defaultTarget, AllocatableValue key, Function<Condition, AArch64Assembler.ConditionFlag> converter) {
        return new AArch64HotSpotStrategySwitchOp(strategy, keyTargets, defaultTarget, key, converter);
    }

    public void setDebugInfoBuilder(HotSpotDebugInfoBuilder debugInfoBuilder) {
        this.debugInfoBuilder = debugInfoBuilder;
    }

    @Override
    public void emitZeroMemory(Value address, Value length, boolean isAligned) {
        EnumSet flags = ((AArch64)this.target().arch).getFlags();
        boolean isDcZvaProhibited = true;
        int zvaLength = this.config.zvaLength;
        if (zvaLength != Integer.MAX_VALUE) {
            isDcZvaProhibited = 0 == zvaLength;
        } else {
            int dczidValue = this.config.psrInfoDczidValue;
            zvaLength = 4 << (dczidValue & 0xF);
            isDcZvaProhibited = (dczidValue & 0x10) != 0;
        }
        boolean useDcZva = !isDcZvaProhibited && flags.contains(AArch64.Flag.UseBlockZeroing);
        this.emitZeroMemory(address, length, isAligned, useDcZva, zvaLength);
    }

    @Override
    public int getArrayLengthOffset() {
        return this.config.arrayOopDescLengthOffset();
    }
}

