/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.UnaryOperator;
import org.graalvm.collections.EconomicSet;
import org.graalvm.collections.Equivalence;

public final class WeakClassLoaderSet {
    private volatile AtomicReference<EconomicSet<Reference<ClassLoader>>> loaders = new AtomicReference<EconomicSet>(EconomicSet.create((Equivalence)RefEquivalence.INSTANCE));

    public WeakClassLoaderSet(ClassLoader ... initialEntries) {
        for (ClassLoader loader : initialEntries) {
            this.loaders.get().add(new WeakReference<ClassLoader>(loader));
        }
    }

    public void add(ClassLoader loader) {
        final WeakReference<ClassLoader> addNewRef = new WeakReference<ClassLoader>(loader);
        EconomicSet<Reference<ClassLoader>> currentLoaders = this.loaders.get();
        if (!currentLoaders.contains(addNewRef)) {
            this.loaders.getAndUpdate(new UnaryOperator<EconomicSet<Reference<ClassLoader>>>(){

                @Override
                public EconomicSet<Reference<ClassLoader>> apply(EconomicSet<Reference<ClassLoader>> t) {
                    EconomicSet newLoaders = EconomicSet.create((Equivalence)RefEquivalence.INSTANCE, t);
                    newLoaders.add((Object)addNewRef);
                    return newLoaders;
                }
            });
        }
    }

    public EconomicSet<Class<?>> resolve(String className, EconomicSet<ClassNotFoundException> resolutionFailures) {
        EconomicSet found = EconomicSet.create();
        Iterator it = this.loaders.get().iterator();
        while (it.hasNext()) {
            Reference ref = (Reference)it.next();
            ClassLoader loader = (ClassLoader)ref.get();
            if (loader == null) {
                it.remove();
                continue;
            }
            try {
                Class<?> clazz = Class.forName(className, false, loader);
                found.add(clazz);
            }
            catch (ClassNotFoundException ex) {
                resolutionFailures.add((Object)ex);
            }
        }
        return found;
    }

    private static final class RefEquivalence
    extends Equivalence {
        static final Equivalence INSTANCE = new RefEquivalence();

        private RefEquivalence() {
        }

        public boolean equals(Object a, Object b) {
            Reference refA = (Reference)a;
            Reference refB = (Reference)b;
            Object referentA = refA.get();
            Object referentB = refB.get();
            return Objects.equals(referentA, referentB);
        }

        public int hashCode(Object o) {
            Reference ref = (Reference)o;
            Object obj = ref.get();
            return obj == null ? 0 : obj.hashCode();
        }
    }
}

