/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Objects;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.meta.SpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.CompilationContext;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class HotSpotGraalServices {
    private static final Method runtimeExitHotSpot;
    private static final Method scopeOpenLocalScope;
    private static final Method scopeEnterGlobalScope;
    private static final Constructor<? extends HotSpotSpeculationLog> hotSpotSpeculationLogConstructor;

    public static CompilationContext enterGlobalCompilationContext() {
        if (scopeEnterGlobalScope != null) {
            try {
                AutoCloseable impl = (AutoCloseable)scopeEnterGlobalScope.invoke(null, new Object[0]);
                return impl == null ? null : new CompilationContext(impl);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        return null;
    }

    public static CompilationContext openLocalCompilationContext(Object description) {
        if (scopeOpenLocalScope != null) {
            try {
                AutoCloseable impl = (AutoCloseable)scopeOpenLocalScope.invoke(null, Objects.requireNonNull(description));
                return impl == null ? null : new CompilationContext(impl);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        }
        return null;
    }

    public static void exit(int status, HotSpotJVMCIRuntime runtime) {
        if (Services.IS_IN_NATIVE_IMAGE) {
            try {
                runtimeExitHotSpot.invoke((Object)runtime, status);
            }
            catch (Throwable throwable) {
                throw new InternalError(throwable);
            }
        } else {
            System.exit(status);
        }
    }

    public static SpeculationLog newHotSpotSpeculationLog(long cachedFailedSpeculationsAddress) {
        if (hotSpotSpeculationLogConstructor != null) {
            try {
                return (SpeculationLog)hotSpotSpeculationLogConstructor.newInstance(cachedFailedSpeculationsAddress);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }
        throw GraalError.shouldNotReachHere();
    }

    static {
        Constructor hslConstructor;
        Method exitHotSpot;
        Method openLocalScope;
        Method enterGlobalScope;
        block2: {
            enterGlobalScope = null;
            openLocalScope = null;
            exitHotSpot = null;
            hslConstructor = null;
            boolean firstFound = false;
            try {
                Class<?> scopeClass = Class.forName("jdk.vm.ci.hotspot.HotSpotObjectConstantScope");
                enterGlobalScope = scopeClass.getDeclaredMethod("enterGlobalScope", new Class[0]);
                firstFound = true;
                openLocalScope = scopeClass.getDeclaredMethod("openLocalScope", Object.class);
                exitHotSpot = HotSpotJVMCIRuntime.class.getDeclaredMethod("exitHotSpot", Integer.TYPE);
                hslConstructor = HotSpotSpeculationLog.class.getDeclaredConstructor(Long.TYPE);
            }
            catch (Exception e) {
                if (!firstFound) break block2;
                throw new InternalError("some JVMCI features are unavailable", e);
            }
        }
        runtimeExitHotSpot = exitHotSpot;
        scopeEnterGlobalScope = enterGlobalScope;
        scopeOpenLocalScope = openLocalScope;
        hotSpotSpeculationLogConstructor = hslConstructor;
    }
}

