/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.hotspot;

import java.util.Arrays;
import jdk.vm.ci.code.Register;
import jdk.vm.ci.code.TargetDescription;
import jdk.vm.ci.code.ValueUtil;
import jdk.vm.ci.meta.JavaConstant;
import jdk.vm.ci.meta.JavaKind;
import jdk.vm.ci.meta.Value;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.asm.Assembler;
import org.graalvm.compiler.core.common.NumUtil;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.hotspot.GraalHotSpotVMConfig;
import org.graalvm.compiler.hotspot.debug.BenchmarkCounters;
import org.graalvm.compiler.hotspot.meta.HotSpotRegistersProvider;
import org.graalvm.compiler.lir.LIRInstruction;
import org.graalvm.compiler.lir.LIRInstructionClass;
import org.graalvm.compiler.lir.LIRValueUtil;

public abstract class HotSpotCounterOp
extends LIRInstruction {
    public static final LIRInstructionClass<HotSpotCounterOp> TYPE = LIRInstructionClass.create(HotSpotCounterOp.class);
    private final String[] names;
    private final String[] groups;
    protected final Register thread;
    protected final GraalHotSpotVMConfig config;
    @LIRInstruction.Alive(value={LIRInstruction.OperandFlag.CONST, LIRInstruction.OperandFlag.REG})
    protected Value[] increments;

    public HotSpotCounterOp(LIRInstructionClass<? extends HotSpotCounterOp> c, String name, String group, Value increment, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config) {
        this(c, new String[]{name}, new String[]{group}, new Value[]{increment}, registers, config);
    }

    public HotSpotCounterOp(LIRInstructionClass<? extends HotSpotCounterOp> c, String[] names, String[] groups, Value[] increments, HotSpotRegistersProvider registers, GraalHotSpotVMConfig config) {
        super(c);
        assert (names.length == groups.length);
        assert (groups.length == increments.length);
        this.names = names;
        this.groups = groups;
        this.increments = increments;
        this.thread = registers.getThreadRegister();
        this.config = config;
        this.checkIncrements();
    }

    private boolean checkIncrements() {
        for (int i = 0; i < this.increments.length; ++i) {
            long incValue;
            Value increment = this.increments[i];
            if (!LIRValueUtil.isJavaConstant(increment) || (incValue = HotSpotCounterOp.asLong(LIRValueUtil.asJavaConstant(increment))) >= 0L && incValue <= 10000L) continue;
            String message = String.format("Benchmark counter %s:%s has increment out of range [%d .. %d]: %d", this.groups[i], this.names[i], 0L, 10000L, incValue);
            assert (false) : message;
        }
        return true;
    }

    protected static int getDisplacementForLongIndex(TargetDescription target, long index) {
        long finalDisp = index * (long)target.arch.getPlatformKind(JavaKind.Long).getSizeInBytes();
        if (!NumUtil.isInt(finalDisp)) {
            throw GraalError.unimplemented("cannot deal with indices that big: " + index);
        }
        return (int)finalDisp;
    }

    protected void forEachCounter(CounterProcedure proc, TargetDescription target) {
        if (this.names.length == 1) {
            int arrayIndex = this.getIndex(this.names[0], this.groups[0], this.increments[0]);
            int displacement = HotSpotCounterOp.getDisplacementForLongIndex(target, arrayIndex);
            proc.apply(0, this.increments[0], displacement);
        } else {
            int[] displacements = new int[this.names.length];
            EconomicMap offsetMap = EconomicMap.create();
            for (int i = 0; i < this.names.length; ++i) {
                int arrayIndex = this.getIndex(this.names[i], this.groups[i], this.increments[i]);
                displacements[i] = HotSpotCounterOp.getDisplacementForLongIndex(target, arrayIndex);
                offsetMap.put((Object)displacements[i], (Object)i);
            }
            Arrays.sort(displacements);
            for (int offset : displacements) {
                int idx = (Integer)offsetMap.get((Object)offset);
                proc.apply(idx, this.increments[idx], displacements[idx]);
            }
        }
    }

    protected int getIndex(String name, String group, Value increment) {
        if (LIRValueUtil.isJavaConstant(increment)) {
            return BenchmarkCounters.getIndexConstantIncrement(name, group, this.config, HotSpotCounterOp.asLong(LIRValueUtil.asJavaConstant(increment)));
        }
        assert (ValueUtil.isRegister((Value)increment)) : "Unexpected Value: " + increment;
        return BenchmarkCounters.getIndex(name, group, this.config);
    }

    public void patchCounterIncrement(Assembler<?> asm, int[] increment) {
        throw GraalError.unimplemented();
    }

    private static long asLong(JavaConstant value) {
        JavaKind kind = value.getJavaKind();
        switch (kind) {
            case Byte: 
            case Short: 
            case Char: 
            case Int: {
                return value.asInt();
            }
            case Long: {
                return value.asLong();
            }
        }
        throw new IllegalArgumentException("not an integer kind: " + kind);
    }

    protected static int asInt(JavaConstant value) {
        long l = HotSpotCounterOp.asLong(value);
        if (!NumUtil.isInt(l)) {
            throw GraalError.shouldNotReachHere("value does not fit into int: " + l);
        }
        return (int)l;
    }

    public String[] getNames() {
        return this.names;
    }

    public String[] getGroups() {
        return this.groups;
    }

    protected static interface CounterProcedure {
        public void apply(int var1, Value var2, int var3);
    }
}

