/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.graph;

import org.graalvm.compiler.graph.GraalGraphError;
import org.graalvm.compiler.graph.Graph;
import org.graalvm.compiler.graph.Node;

class NodeIdAccessor {
    final Graph graph;
    final int epoch;

    NodeIdAccessor(Graph graph) {
        this.graph = graph;
        this.epoch = graph.compressions;
    }

    Graph getGraph() {
        return this.graph;
    }

    boolean verifyIdsAreStable() {
        int compressions = this.graph.compressions - this.epoch;
        if (compressions != 0) {
            throw new GraalGraphError("accessing node id in %s across %d graph compression%s", this.graph, compressions, compressions == 1 ? "" : "s");
        }
        return true;
    }

    int getNodeId(Node node) {
        assert (this.verifyIdsAreStable());
        if (!node.isAlive()) {
            throw new InternalError(node.toString());
        }
        return node.id();
    }
}

