/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.debug;

import java.util.ArrayList;
import java.util.List;
import org.graalvm.collections.EconomicMap;
import org.graalvm.compiler.debug.AbstractKey;
import org.graalvm.compiler.debug.MetricKey;

public class KeyRegistry {
    private static final EconomicMap<String, Integer> keyMap = EconomicMap.create();
    private static final List<AbstractKey> keys = new ArrayList<AbstractKey>();

    static synchronized int register(AbstractKey key) {
        String name = key.getName();
        if (!keyMap.containsKey((Object)name)) {
            keyMap.put((Object)name, (Object)keys.size());
            keys.add(key);
        }
        return (Integer)keyMap.get((Object)name);
    }

    public static synchronized List<MetricKey> getKeys() {
        return new ArrayList<MetricKey>(keys);
    }
}

