/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.PriorityBlockingQueue;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Server;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.replication.ReplicationPeer;
import org.apache.hadoop.hbase.replication.ReplicationQueueStorage;
import org.apache.hadoop.hbase.replication.regionserver.MetricsSource;
import org.apache.hadoop.hbase.replication.regionserver.RecoveredReplicationSourceShipper;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSource;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSourceManager;
import org.apache.hadoop.hbase.replication.regionserver.ReplicationSyncUp;
import org.apache.hadoop.hbase.replication.regionserver.WALFileLengthProvider;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hadoop.hbase.util.Threads;
import org.apache.hadoop.hbase.wal.AbstractFSWALProvider;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class RecoveredReplicationSource
extends ReplicationSource {
    private static final Logger LOG = LoggerFactory.getLogger(RecoveredReplicationSource.class);
    private String actualPeerId;

    @Override
    public void init(Configuration conf, FileSystem fs, ReplicationSourceManager manager, ReplicationQueueStorage queueStorage, ReplicationPeer replicationPeer, Server server, String peerClusterZnode, UUID clusterId, WALFileLengthProvider walFileLengthProvider, MetricsSource metrics) throws IOException {
        super.init(conf, fs, manager, queueStorage, replicationPeer, server, peerClusterZnode, clusterId, walFileLengthProvider, metrics);
        this.actualPeerId = this.replicationQueueInfo.getPeerId();
    }

    @Override
    protected RecoveredReplicationSourceShipper createNewShipper(String walGroupId, PriorityBlockingQueue<Path> queue) {
        return new RecoveredReplicationSourceShipper(this.conf, walGroupId, queue, this, this.queueStorage);
    }

    public void locateRecoveredPaths(PriorityBlockingQueue<Path> queue) throws IOException {
        boolean hasPathChanged = false;
        PriorityBlockingQueue<Path> newPaths = new PriorityBlockingQueue<Path>(this.queueSizePerGroup, new ReplicationSource.LogsComparator());
        block0: for (Path path : queue) {
            if (this.fs.exists(path)) {
                newPaths.add(path);
                continue;
            }
            hasPathChanged = true;
            if (this.server instanceof ReplicationSyncUp.DummyServer) {
                Path newPath = this.getReplSyncUpPath(path);
                newPaths.add(newPath);
                continue;
            }
            List<ServerName> deadRegionServers = this.replicationQueueInfo.getDeadRegionServers();
            LOG.info("NB dead servers : " + deadRegionServers.size());
            Path walDir = FSUtils.getWALRootDir(this.conf);
            for (ServerName curDeadServerName : deadRegionServers) {
                Path[] locs;
                Path deadRsDirectory = new Path(walDir, AbstractFSWALProvider.getWALDirectoryName(curDeadServerName.getServerName()));
                for (Path possibleLogLocation : locs = new Path[]{new Path(deadRsDirectory, path.getName()), new Path(deadRsDirectory.suffix("-splitting"), path.getName())}) {
                    LOG.info("Possible location " + possibleLogLocation.toUri().toString());
                    if (!this.manager.getFs().exists(possibleLogLocation)) continue;
                    LOG.info("Log " + path + " still exists at " + possibleLogLocation);
                    newPaths.add(possibleLogLocation);
                    continue block0;
                }
            }
            LOG.error(String.format("WAL Path %s doesn't exist and couldn't find its new location", path));
            newPaths.add(path);
        }
        if (hasPathChanged) {
            if (newPaths.size() != queue.size()) {
                LOG.error("Recovery queue size is incorrect");
                throw new IOException("Recovery queue size error");
            }
            queue.clear();
            for (Path path : newPaths) {
                queue.add(path);
            }
        }
    }

    private Path getReplSyncUpPath(Path path) throws IOException {
        FileStatus[] rss;
        for (FileStatus rs : rss = this.fs.listStatus(this.manager.getLogDir())) {
            FileStatus[] logs;
            Path p = rs.getPath();
            for (FileStatus log : logs = this.fs.listStatus(p)) {
                if (!(p = new Path(p, log.getPath().getName())).getName().equals(path.getName())) continue;
                LOG.info("Log " + p.getName() + " found at " + p);
                return p;
            }
        }
        LOG.error("Didn't find path for: " + path.getName());
        return path;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void tryFinish() {
        ConcurrentHashMap concurrentHashMap = this.workerThreads;
        synchronized (concurrentHashMap) {
            Threads.sleep(100L);
            boolean allTasksDone = this.workerThreads.values().stream().allMatch(w -> w.isFinished());
            if (allTasksDone) {
                this.getSourceMetrics().clear();
                this.manager.removeRecoveredSource(this);
                LOG.info("Finished recovering queue {} with the following stats: {}", (Object)this.queueId, (Object)this.getStats());
            }
        }
    }

    @Override
    public String getPeerId() {
        return this.actualPeerId;
    }

    @Override
    public ServerName getServerWALsBelongTo() {
        return this.replicationQueueInfo.getDeadRegionServers().get(0);
    }

    @Override
    public boolean isRecovered() {
        return true;
    }
}

