/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.util;

import java.util.Collection;
import java.util.Iterator;
import org.apache.tinkerpop.gremlin.structure.util.CloseableIterator;
import org.janusgraph.graphdb.util.CloseableAbstractIterator;

public class MultiIterator<E>
extends CloseableAbstractIterator<E> {
    private final Iterator<Iterator<E>> collectionIterator;
    private Iterator<E> currentIterator;

    public MultiIterator(Collection<Iterator<E>> iterators) {
        this.collectionIterator = iterators.iterator();
        if (this.collectionIterator.hasNext()) {
            this.currentIterator = this.collectionIterator.next();
        } else {
            this.endOfData();
        }
    }

    protected E computeNext() {
        while (!this.currentIterator.hasNext() && this.collectionIterator.hasNext()) {
            CloseableIterator.closeIterator(this.currentIterator);
            this.currentIterator = this.collectionIterator.next();
        }
        if (this.currentIterator.hasNext()) {
            return this.currentIterator.next();
        }
        CloseableIterator.closeIterator(this.currentIterator);
        this.currentIterator = null;
        return (E)this.endOfData();
    }

    public void close() {
        CloseableIterator.closeIterator(this.currentIterator);
        while (this.collectionIterator.hasNext()) {
            CloseableIterator.closeIterator(this.collectionIterator.next());
        }
    }
}

