/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components;

import java.nio.BufferOverflowException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.AbstractAsn1Object;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.EncoderException;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.BerValue;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.TLV;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.asn1.ber.tlv.UniversalTag;
import org.apache.hadoop.hbase.shaded.org.apache.directory.api.util.Strings;
import org.apache.hadoop.hbase.shaded.org.apache.directory.server.i18n.I18n;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.KerberosTime;
import org.apache.hadoop.hbase.shaded.org.apache.directory.shared.kerberos.components.HostAddress;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KrbSafeBody
extends AbstractAsn1Object {
    private static final Logger log = LoggerFactory.getLogger(KrbSafeBody.class);
    private static final boolean IS_DEBUG = log.isDebugEnabled();
    private byte[] userData;
    private KerberosTime timestamp;
    private Integer usec;
    private Integer seqNumber;
    private HostAddress senderAddress;
    private HostAddress recipientAddress;
    private int userDataLen;
    private int timestampLen;
    private int usecLen;
    private int seqNumberLen;
    private int senderAddressLen;
    private int recipientAddressLen;
    private int krbSafeBodySeqLen;

    public byte[] getUserData() {
        return this.userData;
    }

    public void setUserData(byte[] userData) {
        this.userData = userData;
    }

    public KerberosTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(KerberosTime timestamp) {
        this.timestamp = timestamp;
    }

    public int getUsec() {
        if (this.usec == null) {
            return 0;
        }
        return this.usec;
    }

    public void setUsec(int usec) {
        this.usec = usec;
    }

    public int getSeqNumber() {
        if (this.seqNumber == null) {
            return 0;
        }
        return this.seqNumber;
    }

    public void setSeqNumber(int seqNumber) {
        this.seqNumber = seqNumber;
    }

    public HostAddress getSenderAddress() {
        return this.senderAddress;
    }

    public void setSenderAddress(HostAddress senderAddress) {
        this.senderAddress = senderAddress;
    }

    public HostAddress getRecipientAddress() {
        return this.recipientAddress;
    }

    public void setRecipientAddress(HostAddress recipientAddress) {
        this.recipientAddress = recipientAddress;
    }

    @Override
    public int computeLength() {
        this.userDataLen = 1 + TLV.getNbBytes((int)this.userData.length) + this.userData.length;
        this.krbSafeBodySeqLen = 1 + TLV.getNbBytes((int)this.userDataLen) + this.userDataLen;
        this.senderAddressLen = this.senderAddress.computeLength();
        this.krbSafeBodySeqLen += 1 + TLV.getNbBytes((int)this.senderAddressLen) + this.senderAddressLen;
        if (this.timestamp != null) {
            this.timestampLen = this.timestamp.getBytes().length;
            this.timestampLen = 1 + TLV.getNbBytes((int)this.timestampLen) + this.timestampLen;
            this.krbSafeBodySeqLen += 1 + TLV.getNbBytes((int)this.timestampLen) + this.timestampLen;
        }
        if (this.usec != null) {
            this.usecLen = BerValue.getNbBytes((int)this.usec);
            this.usecLen = 1 + TLV.getNbBytes((int)this.usecLen) + this.usecLen;
            this.krbSafeBodySeqLen += 1 + TLV.getNbBytes((int)this.usecLen) + this.usecLen;
        }
        if (this.seqNumber != null) {
            this.seqNumberLen = BerValue.getNbBytes((int)this.seqNumber);
            this.seqNumberLen = 1 + TLV.getNbBytes((int)this.seqNumberLen) + this.seqNumberLen;
            this.krbSafeBodySeqLen += 1 + TLV.getNbBytes((int)this.seqNumberLen) + this.seqNumberLen;
        }
        if (this.recipientAddress != null) {
            this.recipientAddressLen = this.recipientAddress.computeLength();
            this.krbSafeBodySeqLen += 1 + TLV.getNbBytes((int)this.recipientAddressLen) + this.recipientAddressLen;
        }
        return 1 + TLV.getNbBytes((int)this.krbSafeBodySeqLen) + this.krbSafeBodySeqLen;
    }

    @Override
    public ByteBuffer encode(ByteBuffer buffer) throws EncoderException {
        if (buffer == null) {
            throw new EncoderException(I18n.err(I18n.ERR_148, new Object[0]));
        }
        try {
            buffer.put(UniversalTag.SEQUENCE.getValue());
            buffer.put(TLV.getBytes((int)this.krbSafeBodySeqLen));
            buffer.put((byte)-96);
            buffer.put(TLV.getBytes((int)this.userDataLen));
            BerValue.encode((ByteBuffer)buffer, (byte[])this.userData);
            if (this.timestamp != null) {
                buffer.put((byte)-95);
                buffer.put(TLV.getBytes((int)this.timestampLen));
                buffer.put(UniversalTag.GENERALIZED_TIME.getValue());
                buffer.put((byte)15);
                buffer.put(this.timestamp.getBytes());
            }
            if (this.usec != null) {
                buffer.put((byte)-94);
                buffer.put(TLV.getBytes((int)this.usecLen));
                BerValue.encode((ByteBuffer)buffer, (int)this.usec);
            }
            if (this.seqNumber != null) {
                buffer.put((byte)-93);
                buffer.put(TLV.getBytes((int)this.seqNumberLen));
                BerValue.encode((ByteBuffer)buffer, (int)this.seqNumber);
            }
            buffer.put((byte)-92);
            buffer.put(TLV.getBytes((int)this.senderAddressLen));
            this.senderAddress.encode(buffer);
            if (this.recipientAddress != null) {
                buffer.put((byte)-91);
                buffer.put(TLV.getBytes((int)this.recipientAddressLen));
                this.recipientAddress.encode(buffer);
            }
        }
        catch (BufferOverflowException boe) {
            log.error(I18n.err(I18n.ERR_735_CANNOT_ENCODE_KRBSAFEBODY, 1 + TLV.getNbBytes((int)this.krbSafeBodySeqLen) + this.krbSafeBodySeqLen, buffer.capacity()));
            throw new EncoderException(I18n.err(I18n.ERR_138, new Object[0]));
        }
        if (IS_DEBUG) {
            log.debug("KrbSafeBody encoding : {}", (Object)Strings.dumpBytes(buffer.array()));
            log.debug("KrbSafeBody initial value : {}", (Object)this.toString());
        }
        return buffer;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("KRB-SAFE-BODY : {\n");
        sb.append("    user-data: ").append(Strings.dumpBytes(this.userData)).append('\n');
        if (this.timestamp != null) {
            sb.append("    timestamp: ").append(this.timestamp.getDate()).append('\n');
        }
        if (this.usec != null) {
            sb.append("    usec: ").append(this.usec).append('\n');
        }
        if (this.seqNumber != null) {
            sb.append("    seq-number: ").append(this.seqNumber).append('\n');
        }
        sb.append("    s-address: ").append(this.senderAddress).append('\n');
        if (this.recipientAddress != null) {
            sb.append("    r-address: ").append(this.recipientAddress).append('\n');
        }
        sb.append("}\n");
        return sb.toString();
    }
}

