/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.io.binary;

import java.io.IOException;
import org.apache.tinkerpop.gremlin.structure.io.Buffer;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryReader;
import org.apache.tinkerpop.gremlin.structure.io.binary.GraphBinaryWriter;
import org.janusgraph.graphdb.relations.RelationIdentifier;
import org.janusgraph.graphdb.tinkerpop.io.binary.GraphBinaryType;
import org.janusgraph.graphdb.tinkerpop.io.binary.JanusGraphTypeSerializer;

public class RelationIdentifierGraphBinarySerializer
extends JanusGraphTypeSerializer<RelationIdentifier> {
    public RelationIdentifierGraphBinarySerializer() {
        super(GraphBinaryType.RelationIdentifier);
    }

    @Override
    public RelationIdentifier readNonNullableValue(Buffer buffer, GraphBinaryReader context) throws IOException {
        long outVertexId = buffer.readLong();
        long typeId = buffer.readLong();
        long relationId = buffer.readLong();
        long inVertexId = buffer.readLong();
        return new RelationIdentifier(outVertexId, typeId, relationId, inVertexId);
    }

    @Override
    protected void writeNonNullableValue(RelationIdentifier value, Buffer buffer, GraphBinaryWriter context) throws IOException {
        buffer.writeLong(value.getOutVertexId());
        buffer.writeLong(value.getTypeId());
        buffer.writeLong(value.getRelationId());
        buffer.writeLong(value.getInVertexId());
    }
}

