/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal.step.map;

import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.map.ScalarMapStep;
import org.apache.tinkerpop.gremlin.process.traversal.traverser.TraverserRequirement;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public final class SumLocalStep<E extends Number, S extends Iterable<E>>
extends ScalarMapStep<S, E> {
    public SumLocalStep(Traversal.Admin traversal) {
        super(traversal);
    }

    @Override
    protected E map(Traverser.Admin<S> traverser) {
        Iterator iterator = ((Iterable)traverser.get()).iterator();
        if (iterator.hasNext()) {
            Object result = this.untilNonNull(iterator);
            while (iterator.hasNext()) {
                result = NumberHelper.add(result, (Number)iterator.next());
            }
            return (E)result;
        }
        throw FastNoSuchElementException.instance();
    }

    private E untilNonNull(Iterator<E> itty) {
        Number result = null;
        while (itty.hasNext() && null == result) {
            result = (Number)itty.next();
        }
        return (E)result;
    }

    @Override
    public Set<TraverserRequirement> getRequirements() {
        return Collections.singleton(TraverserRequirement.OBJECT);
    }
}

