/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.storage;

import java.io.Serializable;
import java.util.HashMap;
import org.apache.spark.internal.Logging;
import org.apache.spark.rpc.RpcEndpointRef;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.storage.BlockStatus;
import org.apache.spark.storage.StorageLevel;
import org.apache.spark.storage.StorageLevel$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.LongRef;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005}c!\u0002\u0012$\u0001\u0015Z\u0003\u0002\u0003\u001d\u0001\u0005\u000b\u0007I\u0011\u0001\u001e\t\u0011}\u0002!\u0011!Q\u0001\nmB\u0001\u0002\u0011\u0001\u0003\u0002\u0003\u0006I!\u0011\u0005\t\t\u0002\u0011)\u0019!C\u0001\u000b\"Aa\t\u0001B\u0001B\u0003%\u0011\t\u0003\u0005H\u0001\t\u0015\r\u0011\"\u0001F\u0011!A\u0005A!A!\u0002\u0013\t\u0005\u0002C%\u0001\u0005\u000b\u0007I\u0011\u0001&\t\u0011E\u0003!\u0011!Q\u0001\n-C\u0001B\u0015\u0001\u0003\u0006\u0004%\ta\u0015\u0005\tK\u0002\u0011\t\u0011)A\u0005)\")a\r\u0001C\u0001O\"9q\u000e\u0001b\u0001\n\u0003)\u0005B\u00029\u0001A\u0003%\u0011\tC\u0004r\u0001\t\u0007I\u0011\u0001:\t\rY\u0004\u0001\u0015!\u0003t\u0011\u001d9\b\u00011A\u0005\n\u0015Cq\u0001\u001f\u0001A\u0002\u0013%\u0011\u0010\u0003\u0004\u0000\u0001\u0001\u0006K!\u0011\u0005\t\u0003\u0003\u0001\u0001\u0019!C\u0005\u000b\"I\u00111\u0001\u0001A\u0002\u0013%\u0011Q\u0001\u0005\b\u0003\u0013\u0001\u0001\u0015)\u0003B\u0011%\tY\u0001\u0001b\u0001\n\u0013\ti\u0001C\u0004\u0002\u0010\u0001\u0001\u000b\u0011B,\t\u000f\u0005E\u0001\u0001\"\u0001\u0002\u0014!9\u00111\u0004\u0001\u0005\u0002\u0005u\u0001bBA\u0010\u0001\u0011\u0005\u0011\u0011\u0005\u0005\b\u0003o\u0001A\u0011AA\u001d\u0011\u0019\ti\u0004\u0001C\u0001\u000b\"1\u0011q\b\u0001\u0005\u0002\u0015Cq!!\u0011\u0001\t\u0003\ti\u0001C\u0004\u0002D\u0001!\t%!\u0012\t\u000f\u0005u\u0003\u0001\"\u0001\u0002\u001e\t\u0001\"\t\\8dW6\u000bg.Y4fe&sgm\u001c\u0006\u0003I\u0015\nqa\u001d;pe\u0006<WM\u0003\u0002'O\u0005)1\u000f]1sW*\u0011\u0001&K\u0001\u0007CB\f7\r[3\u000b\u0003)\n1a\u001c:h'\r\u0001AF\r\t\u0003[Aj\u0011A\f\u0006\u0002_\u0005)1oY1mC&\u0011\u0011G\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005M2T\"\u0001\u001b\u000b\u0005U*\u0013\u0001C5oi\u0016\u0014h.\u00197\n\u0005]\"$a\u0002'pO\u001eLgnZ\u0001\u000fE2|7m['b]\u0006<WM]%e\u0007\u0001)\u0012a\u000f\t\u0003yuj\u0011aI\u0005\u0003}\r\u0012aB\u00117pG.l\u0015M\\1hKJLE-A\bcY>\u001c7.T1oC\u001e,'/\u00133!\u0003\u0019!\u0018.\\3NgB\u0011QFQ\u0005\u0003\u0007:\u0012A\u0001T8oO\u0006aQ.\u0019=P]\"+\u0017\r]'f[V\t\u0011)A\u0007nCb|e\u000eS3ba6+W\u000eI\u0001\u000e[\u0006DxJ\u001a4IK\u0006\u0004X*Z7\u0002\u001d5\f\u0007p\u00144g\u0011\u0016\f\u0007/T3nA\u0005i1\u000f\\1wK\u0016sG\r]8j]R,\u0012a\u0013\t\u0003\u0019>k\u0011!\u0014\u0006\u0003\u001d\u0016\n1A\u001d9d\u0013\t\u0001VJ\u0001\bSa\u000e,e\u000e\u001a9pS:$(+\u001a4\u0002\u001dMd\u0017M^3F]\u0012\u0004x.\u001b8uA\u0005\tS\r\u001f;fe:\fGn\u00155vM\u001adWmU3sm&\u001cWM\u00117pG.\u001cF/\u0019;vgV\tA\u000bE\u0002.+^K!A\u0016\u0018\u0003\r=\u0003H/[8o!\u0011AVl\u00182\u000e\u0003eS!AW.\u0002\tU$\u0018\u000e\u001c\u0006\u00029\u0006!!.\u0019<b\u0013\tq\u0016LA\u0004ICNDW*\u00199\u0011\u0005q\u0002\u0017BA1$\u0005\u001d\u0011En\\2l\u0013\u0012\u0004\"\u0001P2\n\u0005\u0011\u001c#a\u0003\"m_\u000e\\7\u000b^1ukN\f!%\u001a=uKJt\u0017\r\\*ik\u001a4G.Z*feZL7-\u001a\"m_\u000e\\7\u000b^1ukN\u0004\u0013A\u0002\u001fj]&$h\bF\u0004iS*\\G.\u001c8\u0011\u0005q\u0002\u0001\"\u0002\u001d\r\u0001\u0004Y\u0004\"\u0002!\r\u0001\u0004\t\u0005\"\u0002#\r\u0001\u0004\t\u0005\"B$\r\u0001\u0004\t\u0005\"B%\r\u0001\u0004Y\u0005\"\u0002*\r\u0001\u0004!\u0016AB7bq6+W.A\u0004nCblU-\u001c\u0011\u0002;\u0015DH/\u001a:oC2\u001c\u0006.\u001e4gY\u0016\u001cVM\u001d<jG\u0016,e.\u00192mK\u0012,\u0012a\u001d\t\u0003[QL!!\u001e\u0018\u0003\u000f\t{w\u000e\\3b]\u0006qR\r\u001f;fe:\fGn\u00155vM\u001adWmU3sm&\u001cW-\u00128bE2,G\rI\u0001\f?2\f7\u000f^*fK:l5/A\b`Y\u0006\u001cHoU3f]6\u001bx\fJ3r)\tQX\u0010\u0005\u0002.w&\u0011AP\f\u0002\u0005+:LG\u000fC\u0004\u007f%\u0005\u0005\t\u0019A!\u0002\u0007a$\u0013'\u0001\u0007`Y\u0006\u001cHoU3f]6\u001b\b%A\u0007`e\u0016l\u0017-\u001b8j]\u001elU-\\\u0001\u0012?J,W.Y5oS:<W*Z7`I\u0015\fHc\u0001>\u0002\b!9a0FA\u0001\u0002\u0004\t\u0015AD0sK6\f\u0017N\\5oO6+W\u000eI\u0001\b?\ndwnY6t+\u00059\u0016\u0001C0cY>\u001c7n\u001d\u0011\u0002\u0013\u001d,Go\u0015;biV\u001cH\u0003BA\u000b\u0003/\u00012!L+c\u0011\u0019\tI\"\u0007a\u0001?\u00069!\r\\8dW&#\u0017\u0001E;qI\u0006$X\rT1tiN+WM\\'t)\u0005Q\u0018aD;qI\u0006$XM\u00117pG.LeNZ8\u0015\u0013i\f\u0019#!\n\u00020\u0005M\u0002BBA\r7\u0001\u0007q\fC\u0004\u0002(m\u0001\r!!\u000b\u0002\u0019M$xN]1hK2+g/\u001a7\u0011\u0007q\nY#C\u0002\u0002.\r\u0012Ab\u0015;pe\u0006<W\rT3wK2Da!!\r\u001c\u0001\u0004\t\u0015aB7f[NK'0\u001a\u0005\u0007\u0003kY\u0002\u0019A!\u0002\u0011\u0011L7o[*ju\u0016\f1B]3n_Z,'\t\\8dWR\u0019!0a\u000f\t\r\u0005eA\u00041\u0001`\u00031\u0011X-\\1j]&tw-T3n\u0003)a\u0017m\u001d;TK\u0016tWj]\u0001\u0007E2|7m[:\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!a\u0012\u0011\t\u0005%\u0013q\u000b\b\u0005\u0003\u0017\n\u0019\u0006E\u0002\u0002N9j!!a\u0014\u000b\u0007\u0005E\u0013(\u0001\u0004=e>|GOP\u0005\u0004\u0003+r\u0013A\u0002)sK\u0012,g-\u0003\u0003\u0002Z\u0005m#AB*ue&twMC\u0002\u0002V9\nQa\u00197fCJ\u0004")
public class BlockManagerInfo
implements Logging {
    private final BlockManagerId blockManagerId;
    private final long timeMs;
    private final long maxOnHeapMem;
    private final long maxOffHeapMem;
    private final RpcEndpointRef slaveEndpoint;
    private final Option<HashMap<BlockId, BlockStatus>> externalShuffleServiceBlockStatus;
    private final long maxMem;
    private final boolean externalShuffleServiceEnabled;
    private long _lastSeenMs;
    private long _remainingMem;
    private final HashMap<BlockId, BlockStatus> _blocks;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public BlockManagerId blockManagerId() {
        return this.blockManagerId;
    }

    public long maxOnHeapMem() {
        return this.maxOnHeapMem;
    }

    public long maxOffHeapMem() {
        return this.maxOffHeapMem;
    }

    public RpcEndpointRef slaveEndpoint() {
        return this.slaveEndpoint;
    }

    public Option<HashMap<BlockId, BlockStatus>> externalShuffleServiceBlockStatus() {
        return this.externalShuffleServiceBlockStatus;
    }

    public long maxMem() {
        return this.maxMem;
    }

    public boolean externalShuffleServiceEnabled() {
        return this.externalShuffleServiceEnabled;
    }

    private long _lastSeenMs() {
        return this._lastSeenMs;
    }

    private void _lastSeenMs_$eq(long x$1) {
        this._lastSeenMs = x$1;
    }

    private long _remainingMem() {
        return this._remainingMem;
    }

    private void _remainingMem_$eq(long x$1) {
        this._remainingMem = x$1;
    }

    private HashMap<BlockId, BlockStatus> _blocks() {
        return this._blocks;
    }

    public Option<BlockStatus> getStatus(BlockId blockId) {
        return Option$.MODULE$.apply((Object)this._blocks().get(blockId));
    }

    public void updateLastSeenMs() {
        this._lastSeenMs_$eq(System.currentTimeMillis());
    }

    public void updateBlockInfo(BlockId blockId, StorageLevel storageLevel, long memSize, long diskSize) {
        block11: {
            StorageLevel originalLevel;
            LongRef originalDiskSize;
            LongRef originalMemSize;
            boolean blockExists;
            block10: {
                this.updateLastSeenMs();
                blockExists = this._blocks().containsKey(blockId);
                originalMemSize = LongRef.create((long)0L);
                originalDiskSize = LongRef.create((long)0L);
                originalLevel = StorageLevel$.MODULE$.NONE();
                if (blockExists) {
                    BlockStatus blockStatus2 = this._blocks().get(blockId);
                    originalLevel = blockStatus2.storageLevel();
                    originalMemSize.elem = blockStatus2.memSize();
                    originalDiskSize.elem = blockStatus2.diskSize();
                    if (originalLevel.useMemory()) {
                        this._remainingMem_$eq(this._remainingMem() + originalMemSize.elem);
                    }
                }
                if (!storageLevel.isValid()) break block10;
                ObjectRef blockStatus3 = ObjectRef.create(null);
                if (storageLevel.useMemory()) {
                    blockStatus3.elem = new BlockStatus(storageLevel, memSize, 0L);
                    this._blocks().put(blockId, (BlockStatus)blockStatus3.elem);
                    this._remainingMem_$eq(this._remainingMem() - memSize);
                    if (blockExists) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(64).append("Updated ").append(blockId).append(" in memory on ").append(this.blockManagerId().hostPort()).append(" (current size: ").append(Utils$.MODULE$.bytesToString(memSize)).append(",").append(" original size: ").append(Utils$.MODULE$.bytesToString(originalMemSize$1.elem)).append(",").append(" free: ").append(Utils$.MODULE$.bytesToString(this._remainingMem())).append(")").toString());
                    } else {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Added ").append(blockId).append(" in memory on ").append(this.blockManagerId().hostPort()).append(" (size: ").append(Utils$.MODULE$.bytesToString(memSize)).append(",").append(" free: ").append(Utils$.MODULE$.bytesToString(this._remainingMem())).append(")").toString());
                    }
                }
                if (storageLevel.useDisk()) {
                    blockStatus3.elem = new BlockStatus(storageLevel, 0L, diskSize);
                    this._blocks().put(blockId, (BlockStatus)blockStatus3.elem);
                    if (blockExists) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(54).append("Updated ").append(blockId).append(" on disk on ").append(this.blockManagerId().hostPort()).append(" (current size: ").append(Utils$.MODULE$.bytesToString(diskSize)).append(",").append(" original size: ").append(Utils$.MODULE$.bytesToString(originalDiskSize$1.elem)).append(")").toString());
                    } else {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(27).append("Added ").append(blockId).append(" on disk on ").append(this.blockManagerId().hostPort()).append(" (size: ").append(Utils$.MODULE$.bytesToString(diskSize)).append(")").toString());
                    }
                }
                this.externalShuffleServiceBlockStatus().foreach((Function1 & Serializable & scala.Serializable)shuffleServiceBlocks -> !blockId.isBroadcast() && ((BlockStatus)blockStatus$1.elem).diskSize() > 0L ? shuffleServiceBlocks.put(blockId, (BlockStatus)blockStatus$1.elem) : BoxedUnit.UNIT);
                break block11;
            }
            if (!blockExists) break block11;
            this._blocks().remove(blockId);
            this.externalShuffleServiceBlockStatus().foreach((Function1 & Serializable & scala.Serializable)blockStatus -> (BlockStatus)blockStatus.remove(blockId));
            if (originalLevel.useMemory()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(39).append("Removed ").append(blockId).append(" on ").append(this.blockManagerId().hostPort()).append(" in memory").append(" (size: ").append(Utils$.MODULE$.bytesToString(originalMemSize$1.elem)).append(",").append(" free: ").append(Utils$.MODULE$.bytesToString(this._remainingMem())).append(")").toString());
            }
            if (originalLevel.useDisk()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(29).append("Removed ").append(blockId).append(" on ").append(this.blockManagerId().hostPort()).append(" on disk").append(" (size: ").append(Utils$.MODULE$.bytesToString(originalDiskSize$1.elem)).append(")").toString());
            }
        }
    }

    public void removeBlock(BlockId blockId) {
        block0: {
            if (!this._blocks().containsKey(blockId)) break block0;
            this._remainingMem_$eq(this._remainingMem() + this._blocks().get(blockId).memSize());
            this._blocks().remove(blockId);
            this.externalShuffleServiceBlockStatus().foreach((Function1 & Serializable & scala.Serializable)blockStatus -> (BlockStatus)blockStatus.remove(blockId));
        }
    }

    public long remainingMem() {
        return this._remainingMem();
    }

    public long lastSeenMs() {
        return this._lastSeenMs();
    }

    public HashMap<BlockId, BlockStatus> blocks() {
        return this._blocks();
    }

    public String toString() {
        return new StringBuilder(18).append("BlockManagerInfo ").append(this.timeMs).append(" ").append(this._remainingMem()).toString();
    }

    public void clear() {
        this._blocks().clear();
    }

    public BlockManagerInfo(BlockManagerId blockManagerId, long timeMs, long maxOnHeapMem, long maxOffHeapMem, RpcEndpointRef slaveEndpoint, Option<HashMap<BlockId, BlockStatus>> externalShuffleServiceBlockStatus) {
        this.blockManagerId = blockManagerId;
        this.timeMs = timeMs;
        this.maxOnHeapMem = maxOnHeapMem;
        this.maxOffHeapMem = maxOffHeapMem;
        this.slaveEndpoint = slaveEndpoint;
        this.externalShuffleServiceBlockStatus = externalShuffleServiceBlockStatus;
        Logging.$init$(this);
        this.maxMem = maxOnHeapMem + maxOffHeapMem;
        this.externalShuffleServiceEnabled = externalShuffleServiceBlockStatus.isDefined();
        this._lastSeenMs = timeMs;
        this._remainingMem = this.maxMem();
        this._blocks = new HashMap();
    }
}

