/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.scheduler;

import java.io.FileInputStream;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.Properties;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext$;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.scheduler.Pool;
import org.apache.spark.scheduler.Schedulable;
import org.apache.spark.scheduler.SchedulableBuilder;
import org.apache.spark.scheduler.SchedulingMode$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.control.NonFatal$;
import scala.xml.Elem;
import scala.xml.Node;
import scala.xml.XML$;

@ScalaSignature(bytes="\u0006\u0001\u0005}e!B\u0012%\u0001\u0019b\u0003\u0002C\u001f\u0001\u0005\u000b\u0007I\u0011A \t\u0011\r\u0003!\u0011!Q\u0001\n\u0001C\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\u0006\u0013\u0002!\tA\u0013\u0005\b\u001d\u0002\u0011\r\u0011\"\u0001P\u0011\u0019q\u0006\u0001)A\u0005!\"9q\f\u0001b\u0001\n\u0003\u0001\u0007B\u00025\u0001A\u0003%\u0011\rC\u0004j\u0001\t\u0007I\u0011\u00011\t\r)\u0004\u0001\u0015!\u0003b\u0011\u001dY\u0007A1A\u0005\u0002\u0001Da\u0001\u001c\u0001!\u0002\u0013\t\u0007bB7\u0001\u0005\u0004%\t\u0001\u0019\u0005\u0007]\u0002\u0001\u000b\u0011B1\t\u000f=\u0004!\u0019!C\u0001A\"1\u0001\u000f\u0001Q\u0001\n\u0005Dq!\u001d\u0001C\u0002\u0013\u0005\u0001\r\u0003\u0004s\u0001\u0001\u0006I!\u0019\u0005\bg\u0002\u0011\r\u0011\"\u0001a\u0011\u0019!\b\u0001)A\u0005C\"9Q\u000f\u0001b\u0001\n\u0003\u0001\u0007B\u0002<\u0001A\u0003%\u0011\rC\u0004x\u0001\t\u0007I\u0011\u0001=\t\u000f\u0005\r\u0001\u0001)A\u0005s\"I\u0011Q\u0001\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003\u001f\u0001\u0001\u0015!\u0003\u0002\n!I\u0011\u0011\u0003\u0001C\u0002\u0013\u0005\u0011q\u0001\u0005\t\u0003'\u0001\u0001\u0015!\u0003\u0002\n!9\u0011Q\u0003\u0001\u0005B\u0005]\u0001bBA\u0010\u0001\u0011%\u0011q\u0003\u0005\b\u0003C\u0001A\u0011BA\u0012\u0011\u001d\tI\u0004\u0001C\u0005\u0003wAq!!\u001d\u0001\t\u0013\t\u0019\bC\u0004\u0002\u0002\u0002!\t%a!\u0003-\u0019\u000b\u0017N]*dQ\u0016$W\u000f\\1cY\u0016\u0014U/\u001b7eKJT!!\n\u0014\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014(BA\u0014)\u0003\u0015\u0019\b/\u0019:l\u0015\tI#&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002W\u0005\u0019qN]4\u0014\t\u0001i3g\u000e\t\u0003]Ej\u0011a\f\u0006\u0002a\u0005)1oY1mC&\u0011!g\f\u0002\u0007\u0003:L(+\u001a4\u0011\u0005Q*T\"\u0001\u0013\n\u0005Y\"#AE*dQ\u0016$W\u000f\\1cY\u0016\u0014U/\u001b7eKJ\u0004\"\u0001O\u001e\u000e\u0003eR!A\u000f\u0014\u0002\u0011%tG/\u001a:oC2L!\u0001P\u001d\u0003\u000f1{wmZ5oO\u0006A!o\\8u!>|Gn\u0001\u0001\u0016\u0003\u0001\u0003\"\u0001N!\n\u0005\t##\u0001\u0002)p_2\f\u0011B]8piB{w\u000e\u001c\u0011\u0002\t\r|gN\u001a\t\u0003\r\u001ek\u0011AJ\u0005\u0003\u0011\u001a\u0012\u0011b\u00159be.\u001cuN\u001c4\u0002\rqJg.\u001b;?)\rYE*\u0014\t\u0003i\u0001AQ!\u0010\u0003A\u0002\u0001CQ\u0001\u0012\u0003A\u0002\u0015\u000b!c]2iK\u0012,H.\u001a:BY2|7MR5mKV\t\u0001\u000bE\u0002/#NK!AU\u0018\u0003\r=\u0003H/[8o!\t!6L\u0004\u0002V3B\u0011akL\u0007\u0002/*\u0011\u0001LP\u0001\u0007yI|w\u000e\u001e \n\u0005i{\u0013A\u0002)sK\u0012,g-\u0003\u0002];\n11\u000b\u001e:j]\u001eT!AW\u0018\u0002'M\u001c\u0007.\u001a3vY\u0016\u0014\u0018\t\u001c7pG\u001aKG.\u001a\u0011\u0002-\u0011+e)Q+M)~\u001b6\tS#E+2+%k\u0018$J\u0019\u0016+\u0012!\u0019\t\u0003E\u001el\u0011a\u0019\u0006\u0003I\u0016\fA\u0001\\1oO*\ta-\u0001\u0003kCZ\f\u0017B\u0001/d\u0003]!UIR!V\u0019R{6k\u0011%F\tVcUIU0G\u00132+\u0005%A\rG\u0003&\u0013vlU\"I\u000b\u0012+F*\u0012*`!J{\u0005+\u0012*U\u0013\u0016\u001b\u0016A\u0007$B\u0013J{6k\u0011%F\tVcUIU0Q%>\u0003VI\u0015+J\u000bN\u0003\u0013!\u0005#F\r\u0006+F\nV0Q\u001f>cuLT!N\u000b\u0006\u0011B)\u0012$B+2#v\fU(P\u0019~s\u0015)T#!\u0003]i\u0015JT%N+6{6\u000bS!S\u000bN{\u0006KU(Q\u000bJ#\u0016,\u0001\rN\u0013:KU*V'`'\"\u000b%+R*`!J{\u0005+\u0012*U3\u0002\n\u0001dU\"I\u000b\u0012+F*\u0013(H?6{E)R0Q%>\u0003VI\u0015+Z\u0003e\u00196\tS#E+2KejR0N\u001f\u0012+u\f\u0015*P!\u0016\u0013F+\u0017\u0011\u0002\u001f]+\u0015j\u0012%U?B\u0013v\nU#S)f\u000b\u0001cV#J\u000f\"#v\f\u0015*P!\u0016\u0013F+\u0017\u0011\u0002%A{u\nT0O\u00036+u\f\u0015*P!\u0016\u0013F+W\u0001\u0014!>{Ej\u0018(B\u001b\u0016{\u0006KU(Q\u000bJ#\u0016\fI\u0001\u000f!>{EjU0Q%>\u0003VI\u0015+Z\u0003=\u0001vj\u0014'T?B\u0013v\nU#S)f\u0003\u0013a\u0006#F\r\u0006+F\nV0T\u0007\"+E)\u0016'J\u001d\u001e{Vj\u0014#F+\u0005I\bC\u0001>~\u001d\t!40\u0003\u0002}I\u0005q1k\u00195fIVd\u0017N\\4N_\u0012,\u0017B\u0001@\u0000\u0005\u00151\u0016\r\\;f\u0013\r\t\ta\f\u0002\f\u000b:,X.\u001a:bi&|g.\u0001\rE\u000b\u001a\u000bU\u000b\u0014+`'\u000eCU\tR+M\u0013:;u,T(E\u000b\u0002\nQ\u0003R#G\u0003VcEkX'J\u001d&kU+T0T\u0011\u0006\u0013V)\u0006\u0002\u0002\nA\u0019a&a\u0003\n\u0007\u00055qFA\u0002J]R\fa\u0003R#G\u0003VcEkX'J\u001d&kU+T0T\u0011\u0006\u0013V\tI\u0001\u000f\t\u00163\u0015)\u0016'U?^+\u0015j\u0012%U\u0003=!UIR!V\u0019R{v+R%H\u0011R\u0003\u0013A\u00032vS2$\u0007k\\8mgR\u0011\u0011\u0011\u0004\t\u0004]\u0005m\u0011bAA\u000f_\t!QK\\5u\u0003A\u0011W/\u001b7e\t\u00164\u0017-\u001e7u!>|G.\u0001\fck&dGMR1jeN\u001b\u0007.\u001a3vY\u0016\u0014\bk\\8m)\u0019\tI\"!\n\u00026!9\u0011qE\u0010A\u0002\u0005%\u0012AA5t!\u0011\tY#!\r\u000e\u0005\u00055\"bAA\u0018K\u0006\u0011\u0011n\\\u0005\u0005\u0003g\tiCA\u0006J]B,Ho\u0015;sK\u0006l\u0007BBA\u001c?\u0001\u00071+\u0001\u0005gS2,g*Y7f\u0003Y9W\r^*dQ\u0016$W\u000f\\5oO6{G-\u001a,bYV,GCCA\u001f\u0003/\n9'a\u001b\u0002pA!\u0011qHA)\u001d\r\t\te\u001f\b\u0005\u0003\u0007\nyE\u0004\u0003\u0002F\u00055c\u0002BA$\u0003\u0017r1AVA%\u0013\u0005Y\u0013BA\u0015+\u0013\t9\u0003&\u0003\u0002&M%!\u00111KA+\u00059\u00196\r[3ek2LgnZ'pI\u0016T!\u0001 \u0013\t\u000f\u0005e\u0003\u00051\u0001\u0002\\\u0005A\u0001o\\8m\u001d>$W\r\u0005\u0003\u0002^\u0005\rTBAA0\u0015\r\t\tgL\u0001\u0004q6d\u0017\u0002BA3\u0003?\u0012AAT8eK\"1\u0011\u0011\u000e\u0011A\u0002M\u000b\u0001\u0002]8pY:\u000bW.\u001a\u0005\b\u0003[\u0002\u0003\u0019AA\u001f\u00031!WMZ1vYR4\u0016\r\\;f\u0011\u0019\t9\u0004\ta\u0001'\u0006Yq-\u001a;J]R4\u0016\r\\;f)1\tI!!\u001e\u0002x\u0005e\u0014QPA@\u0011\u001d\tI&\ta\u0001\u00037Ba!!\u001b\"\u0001\u0004\u0019\u0006BBA>C\u0001\u00071+\u0001\u0007qe>\u0004XM\u001d;z\u001d\u0006lW\rC\u0004\u0002n\u0005\u0002\r!!\u0003\t\r\u0005]\u0012\u00051\u0001T\u0003E\tG\r\u001a+bg.\u001cV\r^'b]\u0006<WM\u001d\u000b\u0007\u00033\t))a$\t\u000f\u0005\u001d%\u00051\u0001\u0002\n\u00069Q.\u00198bO\u0016\u0014\bc\u0001\u001b\u0002\f&\u0019\u0011Q\u0012\u0013\u0003\u0017M\u001b\u0007.\u001a3vY\u0006\u0014G.\u001a\u0005\b\u0003#\u0013\u0003\u0019AAJ\u0003)\u0001(o\u001c9feRLWm\u001d\t\u0005\u0003+\u000bY*\u0004\u0002\u0002\u0018*\u0019\u0011\u0011T3\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003;\u000b9J\u0001\u0006Qe>\u0004XM\u001d;jKN\u0004")
public class FairSchedulableBuilder
implements SchedulableBuilder,
Logging {
    private final Pool rootPool;
    private final Option<String> schedulerAllocFile;
    private final String DEFAULT_SCHEDULER_FILE;
    private final String FAIR_SCHEDULER_PROPERTIES;
    private final String DEFAULT_POOL_NAME;
    private final String MINIMUM_SHARES_PROPERTY;
    private final String SCHEDULING_MODE_PROPERTY;
    private final String WEIGHT_PROPERTY;
    private final String POOL_NAME_PROPERTY;
    private final String POOLS_PROPERTY;
    private final Enumeration.Value DEFAULT_SCHEDULING_MODE;
    private final int DEFAULT_MINIMUM_SHARE;
    private final int DEFAULT_WEIGHT;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    @Override
    public Pool rootPool() {
        return this.rootPool;
    }

    public Option<String> schedulerAllocFile() {
        return this.schedulerAllocFile;
    }

    public String DEFAULT_SCHEDULER_FILE() {
        return this.DEFAULT_SCHEDULER_FILE;
    }

    public String FAIR_SCHEDULER_PROPERTIES() {
        return this.FAIR_SCHEDULER_PROPERTIES;
    }

    public String DEFAULT_POOL_NAME() {
        return this.DEFAULT_POOL_NAME;
    }

    public String MINIMUM_SHARES_PROPERTY() {
        return this.MINIMUM_SHARES_PROPERTY;
    }

    public String SCHEDULING_MODE_PROPERTY() {
        return this.SCHEDULING_MODE_PROPERTY;
    }

    public String WEIGHT_PROPERTY() {
        return this.WEIGHT_PROPERTY;
    }

    public String POOL_NAME_PROPERTY() {
        return this.POOL_NAME_PROPERTY;
    }

    public String POOLS_PROPERTY() {
        return this.POOLS_PROPERTY;
    }

    public Enumeration.Value DEFAULT_SCHEDULING_MODE() {
        return this.DEFAULT_SCHEDULING_MODE;
    }

    public int DEFAULT_MINIMUM_SHARE() {
        return this.DEFAULT_MINIMUM_SHARE;
    }

    public int DEFAULT_WEIGHT() {
        return this.DEFAULT_WEIGHT;
    }

    @Override
    public void buildPools() {
        None$ fileData = None$.MODULE$;
        try {
            try {
                fileData = (Option)this.schedulerAllocFile().map((Function1 & Serializable & scala.Serializable)f -> {
                    FileInputStream fis = new FileInputStream((String)f);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(35).append("Creating Fair Scheduler pools from ").append((String)f).toString());
                    return new Some((Object)new Tuple2((Object)fis, f));
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    None$ none$;
                    InputStream is = Utils$.MODULE$.getSparkClassLoader().getResourceAsStream(this.DEFAULT_SCHEDULER_FILE());
                    if (is != null) {
                        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(49).append("Creating Fair Scheduler pools from default file: ").append(this.DEFAULT_SCHEDULER_FILE()).toString());
                        none$ = new Some((Object)new Tuple2((Object)is, (Object)this.DEFAULT_SCHEDULER_FILE()));
                    } else {
                        this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(179).append("Fair Scheduler configuration file not found so jobs will be scheduled in ").append("FIFO order. To use fair scheduling, configure pools in ").append(this.DEFAULT_SCHEDULER_FILE()).append(" or ").append("set ").append(package$.MODULE$.SCHEDULER_ALLOCATION_FILE().key()).append(" to a file that contains the configuration.").toString());
                        none$ = None$.MODULE$;
                    }
                    return none$;
                });
                fileData.foreach((Function1 & Serializable & scala.Serializable)x0$1 -> {
                    FairSchedulableBuilder.$anonfun$buildPools$6(this, x0$1);
                    return BoxedUnit.UNIT;
                });
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable t = (Throwable)option.get();
                    String defaultMessage = "Error while building the fair scheduler pools";
                    String message = (String)fileData.map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                        Tuple2 tuple2 = x0$2;
                        if (tuple2 == null) {
                            throw new MatchError((Object)tuple2);
                        }
                        String fileName = (String)tuple2._2();
                        String string = new StringBuilder(6).append(defaultMessage).append(" from ").append(fileName).toString();
                        return string;
                    }).getOrElse((Function0 & Serializable & scala.Serializable)() -> defaultMessage);
                    this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message, t);
                    throw t;
                }
                throw throwable;
            }
        }
        finally {
            fileData.foreach((Function1 & Serializable & scala.Serializable)x0$3 -> {
                FairSchedulableBuilder.$anonfun$buildPools$10(x0$3);
                return BoxedUnit.UNIT;
            });
        }
        this.buildDefaultPool();
    }

    private void buildDefaultPool() {
        block0: {
            if (this.rootPool().getSchedulableByName(this.DEFAULT_POOL_NAME()) != null) break block0;
            Pool pool = new Pool(this.DEFAULT_POOL_NAME(), this.DEFAULT_SCHEDULING_MODE(), this.DEFAULT_MINIMUM_SHARE(), this.DEFAULT_WEIGHT());
            this.rootPool().addSchedulable(pool);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created default pool: %s, schedulingMode: %s, minShare: %d, weight: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.DEFAULT_POOL_NAME(), this.DEFAULT_SCHEDULING_MODE(), BoxesRunTime.boxToInteger((int)this.DEFAULT_MINIMUM_SHARE()), BoxesRunTime.boxToInteger((int)this.DEFAULT_WEIGHT())})));
        }
    }

    private void buildFairSchedulerPool(InputStream is, String fileName) {
        Elem xml = (Elem)XML$.MODULE$.load(is);
        xml.$bslash$bslash(this.POOLS_PROPERTY()).foreach((Function1 & Serializable & scala.Serializable)poolNode -> {
            FairSchedulableBuilder.$anonfun$buildFairSchedulerPool$1(this, fileName, poolNode);
            return BoxedUnit.UNIT;
        });
    }

    private Enumeration.Value getSchedulingModeValue(Node poolNode, String poolName, Enumeration.Value defaultValue, String fileName) {
        Enumeration.Value value;
        block3: {
            String xmlSchedulingMode = poolNode.$bslash(this.SCHEDULING_MODE_PROPERTY()).text().trim().toUpperCase(Locale.ROOT);
            String warningMessage = new StringBuilder(120).append("Unsupported schedulingMode: ").append(xmlSchedulingMode).append(" found in ").append("Fair Scheduler configuration file: ").append(fileName).append(", using ").append("the default schedulingMode: ").append(defaultValue).append(" for pool: ").append(poolName).toString();
            try {
                Enumeration.Value value2 = SchedulingMode$.MODULE$.withName(xmlSchedulingMode);
                Enumeration.Value value3 = SchedulingMode$.MODULE$.NONE();
                if (value2 == null ? value3 != null : !value2.equals(value3)) {
                    value = SchedulingMode$.MODULE$.withName(xmlSchedulingMode);
                    break block3;
                }
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
                value = defaultValue;
            }
            catch (NoSuchElementException e) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warningMessage);
                value = defaultValue;
            }
        }
        return value;
    }

    private int getIntValue(Node poolNode, String poolName, String propertyName, int defaultValue, String fileName) {
        int n;
        String data = poolNode.$bslash(propertyName).text().trim();
        try {
            n = new StringOps(Predef$.MODULE$.augmentString(data)).toInt();
        }
        catch (NumberFormatException e) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(111).append("Error while loading fair scheduler configuration from ").append(fileName).append(": ").append(propertyName).append(" is blank or invalid: ").append(data).append(", using the default ").append(propertyName).append(": ").append(defaultValue).append(" for pool: ").append(poolName).toString());
            n = defaultValue;
        }
        return n;
    }

    @Override
    public void addTaskSetManager(Schedulable manager, Properties properties) {
        String poolName = properties != null ? properties.getProperty(this.FAIR_SCHEDULER_PROPERTIES(), this.DEFAULT_POOL_NAME()) : this.DEFAULT_POOL_NAME();
        Schedulable parentPool = this.rootPool().getSchedulableByName(poolName);
        if (parentPool == null) {
            parentPool = new Pool(poolName, this.DEFAULT_SCHEDULING_MODE(), this.DEFAULT_MINIMUM_SHARE(), this.DEFAULT_WEIGHT());
            this.rootPool().addSchedulable(parentPool);
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(251).append("A job was submitted with scheduler pool ").append(poolName).append(", which has not been ").append("configured. This can happen when the file that pools are read from isn't set, or ").append("when that file doesn't contain ").append(poolName).append(". Created ").append(poolName).append(" with default ").append("configuration (schedulingMode: ").append(this.DEFAULT_SCHEDULING_MODE()).append(", ").append("minShare: ").append(this.DEFAULT_MINIMUM_SHARE()).append(", weight: ").append(this.DEFAULT_WEIGHT()).append(")").toString());
        }
        parentPool.addSchedulable(manager);
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(30).append("Added task set ").append(manager.name()).append(" tasks to pool ").append(poolName).toString());
    }

    public static final /* synthetic */ void $anonfun$buildPools$6(FairSchedulableBuilder $this, Tuple2 x0$1) {
        Tuple2 tuple2 = x0$1;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream is = (InputStream)tuple2._1();
        String fileName = (String)tuple2._2();
        $this.buildFairSchedulerPool(is, fileName);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildPools$10(Tuple2 x0$3) {
        Tuple2 tuple2 = x0$3;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        InputStream is = (InputStream)tuple2._1();
        is.close();
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ void $anonfun$buildFairSchedulerPool$1(FairSchedulableBuilder $this, String fileName$1, Node poolNode) {
        String poolName = poolNode.$bslash($this.POOL_NAME_PROPERTY()).text();
        Enumeration.Value schedulingMode = $this.getSchedulingModeValue(poolNode, poolName, $this.DEFAULT_SCHEDULING_MODE(), fileName$1);
        int minShare = $this.getIntValue(poolNode, poolName, $this.MINIMUM_SHARES_PROPERTY(), $this.DEFAULT_MINIMUM_SHARE(), fileName$1);
        int weight = $this.getIntValue(poolNode, poolName, $this.WEIGHT_PROPERTY(), $this.DEFAULT_WEIGHT(), fileName$1);
        $this.rootPool().addSchedulable(new Pool(poolName, schedulingMode, minShare, weight));
        $this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringOps(Predef$.MODULE$.augmentString("Created pool: %s, schedulingMode: %s, minShare: %d, weight: %d")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{poolName, schedulingMode, BoxesRunTime.boxToInteger((int)minShare), BoxesRunTime.boxToInteger((int)weight)})));
    }

    public FairSchedulableBuilder(Pool rootPool, SparkConf conf) {
        this.rootPool = rootPool;
        Logging.$init$(this);
        this.schedulerAllocFile = (Option)conf.get(package$.MODULE$.SCHEDULER_ALLOCATION_FILE());
        this.DEFAULT_SCHEDULER_FILE = "fairscheduler.xml";
        this.FAIR_SCHEDULER_PROPERTIES = SparkContext$.MODULE$.SPARK_SCHEDULER_POOL();
        this.DEFAULT_POOL_NAME = "default";
        this.MINIMUM_SHARES_PROPERTY = "minShare";
        this.SCHEDULING_MODE_PROPERTY = "schedulingMode";
        this.WEIGHT_PROPERTY = "weight";
        this.POOL_NAME_PROPERTY = "@name";
        this.POOLS_PROPERTY = "pool";
        this.DEFAULT_SCHEDULING_MODE = SchedulingMode$.MODULE$.FIFO();
        this.DEFAULT_MINIMUM_SHARE = 0;
        this.DEFAULT_WEIGHT = 1;
    }
}

