/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.net.URL;
import java.util.ServiceLoader;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.io.ArrayWritable;
import org.apache.hadoop.io.Writable;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkException;
import org.apache.spark.SparkMasterRegex$;
import org.apache.spark.deploy.LocalSparkCluster;
import org.apache.spark.internal.Logging;
import org.apache.spark.internal.config.package$;
import org.apache.spark.resource.ResourceID;
import org.apache.spark.resource.ResourceRequirement;
import org.apache.spark.resource.ResourceUtils$;
import org.apache.spark.scheduler.ExternalClusterManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.TaskScheduler;
import org.apache.spark.scheduler.TaskSchedulerImpl;
import org.apache.spark.scheduler.cluster.StandaloneSchedulerBackend;
import org.apache.spark.scheduler.local.LocalSchedulerBackend;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.JavaConverters$;
import scala.collection.LinearSeqOptimized;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;
import scala.util.control.NonFatal$;

public final class SparkContext$
implements Logging {
    public static SparkContext$ MODULE$;
    private final Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    private final Object SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    private final AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext;
    private Option<SparkContext> contextBeingConstructed;
    private final String SPARK_JOB_DESCRIPTION;
    private final String SPARK_JOB_GROUP_ID;
    private final String SPARK_JOB_INTERRUPT_ON_CANCEL;
    private final String SPARK_SCHEDULER_POOL;
    private final String RDD_SCOPE_KEY;
    private final String RDD_SCOPE_NO_OVERRIDE_KEY;
    private final String DRIVER_IDENTIFIER;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparkContext$();
    }

    @Override
    public String logName() {
        return Logging.logName$(this);
    }

    @Override
    public Logger log() {
        return Logging.log$(this);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging.logInfo$(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging.logDebug$(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging.logTrace$(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging.logWarning$(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging.logError$(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$(this, msg, throwable);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$(this, msg, throwable);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$(this, isInterpreter);
    }

    @Override
    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$(this, isInterpreter, silent);
    }

    @Override
    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$(this);
    }

    @Override
    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$(this, isInterpreter, silent);
    }

    @Override
    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    @Override
    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String $lessinit$greater$default$3() {
        return null;
    }

    public Seq<String> $lessinit$greater$default$4() {
        return Nil$.MODULE$;
    }

    public Map<String, String> $lessinit$greater$default$5() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public Set<String> org$apache$spark$SparkContext$$VALID_LOG_LEVELS() {
        return this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS;
    }

    private Object SPARK_CONTEXT_CONSTRUCTOR_LOCK() {
        return this.SPARK_CONTEXT_CONSTRUCTOR_LOCK;
    }

    public AtomicReference<SparkContext> org$apache$spark$SparkContext$$activeContext() {
        return this.org$apache$spark$SparkContext$$activeContext;
    }

    private Option<SparkContext> contextBeingConstructed() {
        return this.contextBeingConstructed;
    }

    private void contextBeingConstructed_$eq(Option<SparkContext> x$1) {
        this.contextBeingConstructed = x$1;
    }

    private void assertNoOtherContextIsRunning(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get()).filter((Function1 & Serializable & scala.Serializable)x$37 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$1(sc, x$37))).foreach((Function1 & Serializable & scala.Serializable)ctx -> {
                String errMsg = new StringBuilder(120).append("Only one SparkContext should be running in this JVM (see SPARK-2243).").append("The currently running SparkContext was created at:\n").append(ctx.org$apache$spark$SparkContext$$creationSite().longForm()).toString();
                throw new SparkException(errMsg);
            });
            this.contextBeingConstructed().filter((Function1 & Serializable & scala.Serializable)x$38 -> BoxesRunTime.boxToBoolean((boolean)SparkContext$.$anonfun$assertNoOtherContextIsRunning$3(sc, x$38))).foreach((Function1 & Serializable & scala.Serializable)otherContext -> {
                SparkContext$.$anonfun$assertNoOtherContextIsRunning$4(otherContext);
                return BoxedUnit.UNIT;
            });
        }
    }

    public SparkContext getOrCreate(SparkConf config) {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext(config));
            } else if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])config.getAll())).nonEmpty()) {
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Using an existing SparkContext; some configuration may not take effect.");
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public SparkContext getOrCreate() {
        SparkContext sparkContext;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            if (this.org$apache$spark$SparkContext$$activeContext().get() == null) {
                this.setActiveContext(new SparkContext());
            }
            sparkContext = this.org$apache$spark$SparkContext$$activeContext().get();
        }
        return sparkContext;
    }

    public Option<SparkContext> getActive() {
        Option option;
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            option = Option$.MODULE$.apply((Object)this.org$apache$spark$SparkContext$$activeContext().get());
        }
        return option;
    }

    public void markPartiallyConstructed(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)new Some((Object)sc));
        }
    }

    public void setActiveContext(SparkContext sc) {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.assertNoOtherContextIsRunning(sc);
            this.contextBeingConstructed_$eq((Option<SparkContext>)None$.MODULE$);
            this.org$apache$spark$SparkContext$$activeContext().set(sc);
        }
    }

    public void clearActiveContext() {
        Object object = this.SPARK_CONTEXT_CONSTRUCTOR_LOCK();
        synchronized (object) {
            this.org$apache$spark$SparkContext$$activeContext().set(null);
        }
    }

    public String SPARK_JOB_DESCRIPTION() {
        return this.SPARK_JOB_DESCRIPTION;
    }

    public String SPARK_JOB_GROUP_ID() {
        return this.SPARK_JOB_GROUP_ID;
    }

    public String SPARK_JOB_INTERRUPT_ON_CANCEL() {
        return this.SPARK_JOB_INTERRUPT_ON_CANCEL;
    }

    public String SPARK_SCHEDULER_POOL() {
        return this.SPARK_SCHEDULER_POOL;
    }

    public String RDD_SCOPE_KEY() {
        return this.RDD_SCOPE_KEY;
    }

    public String RDD_SCOPE_NO_OVERRIDE_KEY() {
        return this.RDD_SCOPE_NO_OVERRIDE_KEY;
    }

    public String DRIVER_IDENTIFIER() {
        return this.DRIVER_IDENTIFIER;
    }

    private <T extends Writable> ArrayWritable arrayToArrayWritable(Iterable<T> arr, ClassTag<T> evidence$17) {
        return new ArrayWritable(scala.reflect.package$.MODULE$.classTag(evidence$17).runtimeClass(), (Writable[])((TraversableOnce)arr.map((Function1 & Serializable & scala.Serializable)x -> SparkContext$.anyToWritable$1(x), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Writable.class)));
    }

    public Option<String> jarOfClass(Class<?> cls) {
        String uriStr;
        URL uri = cls.getResource(new StringBuilder(7).append("/").append(cls.getName().replace('.', '/')).append(".class").toString());
        return uri != null ? ((uriStr = uri.toString()).startsWith("jar:file:") ? new Some((Object)uriStr.substring("jar:file:".length(), uriStr.indexOf(33))) : None$.MODULE$) : None$.MODULE$;
    }

    public Option<String> jarOfObject(Object obj) {
        return this.jarOfClass(obj.getClass());
    }

    public SparkConf updatedConf(SparkConf conf, String master, String appName, String sparkHome, Seq<String> jars, Map<String, String> environment) {
        SparkConf res = conf.clone();
        res.setMaster(master);
        res.setAppName(appName);
        Object object = sparkHome != null ? res.setSparkHome(sparkHome) : BoxedUnit.UNIT;
        Object object2 = jars != null && !jars.isEmpty() ? res.setJars(jars) : BoxedUnit.UNIT;
        res.setExecutorEnv((Seq<Tuple2<String, String>>)environment.toSeq());
        return res;
    }

    public String updatedConf$default$4() {
        return null;
    }

    public Seq<String> updatedConf$default$5() {
        return Nil$.MODULE$;
    }

    public Map<String, String> updatedConf$default$6() {
        return (Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
    }

    public int numDriverCores(String master) {
        return this.numDriverCores(master, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int numDriverCores(String master, SparkConf conf) {
        String string = master;
        if ("local".equals(string)) {
            return 1;
        }
        Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
        if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
            String threads = (String)((LinearSeqOptimized)option.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
        if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
            String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
            return SparkContext$.convertToInt$1(threads);
        }
        if (!"yarn".equals(string)) return 0;
        if (conf == null) return 0;
        String string2 = conf.get(package$.MODULE$.SUBMIT_DEPLOY_MODE());
        String string3 = "cluster";
        if (string2 == null) {
            if (string3 != null) {
                return 0;
            }
        } else if (!string2.equals(string3)) return 0;
        int n = conf.getInt(package$.MODULE$.DRIVER_CORES().key(), 0);
        return n;
    }

    public Tuple2<SchedulerBackend, TaskScheduler> org$apache$spark$SparkContext$$createTaskScheduler(SparkContext sc, String master, String deployMode) {
        Tuple2 tuple2;
        int MAX_LOCAL_TASK_FAILURES = 1;
        String string = master;
        if ("local".equals(string)) {
            this.checkResourcesPerTask$1(false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)1)), sc, master);
            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
            LocalSchedulerBackend backend2 = new LocalSchedulerBackend(sc.getConf(), scheduler, 1);
            scheduler.initialize(backend2);
            tuple2 = new Tuple2((Object)backend2, (Object)scheduler);
        } else {
            Option option = SparkMasterRegex$.MODULE$.LOCAL_N_REGEX().unapplySeq((CharSequence)string);
            if (!option.isEmpty() && option.get() != null && ((LinearSeqOptimized)option.get()).lengthCompare(1) == 0) {
                int threadCount;
                String threads;
                String string2 = threads = (String)((LinearSeqOptimized)option.get()).apply(0);
                String string3 = "*";
                int n = !(string2 != null ? !string2.equals(string3) : string3 != null) ? SparkContext$.localCpuCount$1() : (threadCount = new StringOps(Predef$.MODULE$.augmentString(threads)).toInt());
                if (threadCount <= 0) {
                    throw new SparkException(new StringBuilder(34).append("Asked to run locally with ").append(threadCount).append(" threads").toString());
                }
                this.checkResourcesPerTask$1(false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)threadCount)), sc, master);
                TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, MAX_LOCAL_TASK_FAILURES, true);
                LocalSchedulerBackend backend3 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                scheduler.initialize(backend3);
                tuple2 = new Tuple2((Object)backend3, (Object)scheduler);
            } else {
                Option option2 = SparkMasterRegex$.MODULE$.LOCAL_N_FAILURES_REGEX().unapplySeq((CharSequence)string);
                if (!option2.isEmpty() && option2.get() != null && ((LinearSeqOptimized)option2.get()).lengthCompare(2) == 0) {
                    String threads = (String)((LinearSeqOptimized)option2.get()).apply(0);
                    String maxFailures = (String)((LinearSeqOptimized)option2.get()).apply(1);
                    String string4 = threads;
                    String string5 = "*";
                    int threadCount = !(string4 != null ? !string4.equals(string5) : string5 != null) ? SparkContext$.localCpuCount$2() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
                    this.checkResourcesPerTask$1(false, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)threadCount)), sc, master);
                    TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc, new StringOps(Predef$.MODULE$.augmentString(maxFailures)).toInt(), true);
                    LocalSchedulerBackend backend4 = new LocalSchedulerBackend(sc.getConf(), scheduler, threadCount);
                    scheduler.initialize(backend4);
                    tuple2 = new Tuple2((Object)backend4, (Object)scheduler);
                } else {
                    Option option3 = SparkMasterRegex$.MODULE$.SPARK_REGEX().unapplySeq((CharSequence)string);
                    if (!option3.isEmpty() && option3.get() != null && ((LinearSeqOptimized)option3.get()).lengthCompare(1) == 0) {
                        String sparkUrl = (String)((LinearSeqOptimized)option3.get()).apply(0);
                        this.checkResourcesPerTask$1(true, (Option)None$.MODULE$, sc, master);
                        TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                        String[] masterUrls = (String[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])sparkUrl.split(","))).map((Function1 & Serializable & scala.Serializable)x$41 -> new StringBuilder(8).append("spark://").append((String)x$41).toString(), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(String.class)));
                        StandaloneSchedulerBackend backend5 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                        scheduler.initialize(backend5);
                        tuple2 = new Tuple2((Object)backend5, (Object)scheduler);
                    } else {
                        Option option4 = SparkMasterRegex$.MODULE$.LOCAL_CLUSTER_REGEX().unapplySeq((CharSequence)string);
                        if (!option4.isEmpty() && option4.get() != null && ((LinearSeqOptimized)option4.get()).lengthCompare(3) == 0) {
                            String numSlaves = (String)((LinearSeqOptimized)option4.get()).apply(0);
                            String coresPerSlave = (String)((LinearSeqOptimized)option4.get()).apply(1);
                            String memoryPerSlave = (String)((LinearSeqOptimized)option4.get()).apply(2);
                            this.checkResourcesPerTask$1(true, (Option)new Some((Object)BoxesRunTime.boxToInteger((int)new StringOps(Predef$.MODULE$.augmentString(coresPerSlave)).toInt())), sc, master);
                            int memoryPerSlaveInt = new StringOps(Predef$.MODULE$.augmentString(memoryPerSlave)).toInt();
                            if (sc.executorMemory() > memoryPerSlaveInt) {
                                throw new SparkException(new StringOps(Predef$.MODULE$.augmentString("Asked to launch cluster with %d MiB RAM / worker but requested %d MiB/worker")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)memoryPerSlaveInt), BoxesRunTime.boxToInteger((int)sc.executorMemory())})));
                            }
                            sc.conf().setIfMissing(package$.MODULE$.SHUFFLE_HOST_LOCAL_DISK_READING_ENABLED(), BoxesRunTime.boxToBoolean((boolean)false));
                            TaskSchedulerImpl scheduler = new TaskSchedulerImpl(sc);
                            LocalSparkCluster localCluster = new LocalSparkCluster(new StringOps(Predef$.MODULE$.augmentString(numSlaves)).toInt(), new StringOps(Predef$.MODULE$.augmentString(coresPerSlave)).toInt(), memoryPerSlaveInt, sc.conf());
                            String[] masterUrls = localCluster.start();
                            StandaloneSchedulerBackend backend6 = new StandaloneSchedulerBackend(scheduler, sc, masterUrls);
                            scheduler.initialize(backend6);
                            backend6.shutdownCallback_$eq((Function1<StandaloneSchedulerBackend, BoxedUnit>)(Function1 & Serializable & scala.Serializable)backend -> {
                                localCluster.stop();
                                return BoxedUnit.UNIT;
                            });
                            tuple2 = new Tuple2((Object)backend6, (Object)scheduler);
                        } else {
                            Tuple2 tuple22;
                            ExternalClusterManager clusterMgr;
                            this.checkResourcesPerTask$1(true, (Option)None$.MODULE$, sc, master);
                            Option<ExternalClusterManager> option5 = this.getClusterManager(string);
                            if (!(option5 instanceof Some)) {
                                if (None$.MODULE$.equals(option5)) {
                                    throw new SparkException(new StringBuilder(30).append("Could not parse Master URL: '").append(master).append("'").toString());
                                }
                                throw new MatchError(option5);
                            }
                            Some some = (Some)option5;
                            ExternalClusterManager externalClusterManager = clusterMgr = (ExternalClusterManager)some.value();
                            ExternalClusterManager cm = externalClusterManager;
                            try {
                                TaskScheduler scheduler = cm.createTaskScheduler(sc, string);
                                SchedulerBackend backend7 = cm.createSchedulerBackend(sc, string, scheduler);
                                cm.initialize(scheduler, backend7);
                                tuple22 = new Tuple2((Object)backend7, (Object)scheduler);
                            }
                            catch (Throwable throwable) {
                                Throwable throwable2 = throwable;
                                if (throwable2 instanceof SparkException) {
                                    SparkException sparkException = (SparkException)throwable2;
                                    throw sparkException;
                                }
                                Option option6 = NonFatal$.MODULE$.unapply(throwable2);
                                if (!option6.isEmpty()) {
                                    Throwable e = (Throwable)option6.get();
                                    throw new SparkException("External scheduler cannot be instantiated", e);
                                }
                                throw throwable;
                            }
                            tuple2 = tuple22;
                        }
                    }
                }
            }
        }
        return tuple2;
    }

    private Option<ExternalClusterManager> getClusterManager(String url) {
        ClassLoader loader = Utils$.MODULE$.getContextOrSparkClassLoader();
        Iterable serviceLoaders = (Iterable)((TraversableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(ServiceLoader.load(ExternalClusterManager.class, loader)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$42 -> BoxesRunTime.boxToBoolean((boolean)x$42.canCreate(url)));
        if (serviceLoaders.size() > 1) {
            throw new SparkException(new StringBuilder(60).append("Multiple external cluster managers registered for the url ").append(url).append(": ").append(serviceLoaders).toString());
        }
        return serviceLoaders.headOption();
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$1(SparkContext sc$1, SparkContext x$37) {
        return x$37 != sc$1;
    }

    public static final /* synthetic */ boolean $anonfun$assertNoOtherContextIsRunning$3(SparkContext sc$1, SparkContext x$38) {
        return x$38 != sc$1;
    }

    public static final /* synthetic */ void $anonfun$assertNoOtherContextIsRunning$4(SparkContext otherContext) {
        String otherContextCreationSite = (String)Option$.MODULE$.apply((Object)otherContext.org$apache$spark$SparkContext$$creationSite()).map((Function1 & Serializable & scala.Serializable)x$39 -> x$39.longForm()).getOrElse((Function0 & Serializable & scala.Serializable)() -> "unknown location");
        String warnMsg = new StringBuilder(229).append("Another SparkContext is being constructed (or threw an exception in its constructor). This may indicate an error, since only one SparkContext should be running in this JVM (see SPARK-2243).").append(" The other SparkContext was created at:\n").append(otherContextCreationSite).toString();
        MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> warnMsg);
    }

    private static final Writable anyToWritable$1(Writable u) {
        return u;
    }

    private static final int convertToInt$1(String threads) {
        String string = threads;
        String string2 = "*";
        return !(string != null ? !string.equals(string2) : string2 != null) ? Runtime.getRuntime().availableProcessors() : new StringOps(Predef$.MODULE$.augmentString(threads)).toInt();
    }

    public static final /* synthetic */ void $anonfun$createTaskScheduler$3(scala.collection.immutable.Map executorResourcesAndAmounts$1, IntRef numSlots$1, boolean shouldCheckExecCores$1, ObjectRef limitingResourceName$1, ResourceRequirement taskReq) {
        block2: {
            long execAmount = BoxesRunTime.unboxToLong((Object)executorResourcesAndAmounts$1.getOrElse((Object)taskReq.resourceName(), (Function0 & Serializable & scala.Serializable)() -> {
                throw new SparkException(new StringBuilder(100).append("The executor resource config: ").append(new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), taskReq.resourceName()).amountConf()).append(" needs to be specified since a task requirement config: ").append(new ResourceID(package$.MODULE$.SPARK_TASK_PREFIX(), taskReq.resourceName()).amountConf()).append(" was specified").toString());
            }));
            if (execAmount < (long)taskReq.amount()) {
                throw new SparkException(new StringBuilder(96).append("The executor resource config: ").append(new ResourceID(package$.MODULE$.SPARK_EXECUTOR_PREFIX(), taskReq.resourceName()).amountConf()).append(" = ").append(execAmount).append(" has to be >= the requested amount in task resource config: ").append(new ResourceID(package$.MODULE$.SPARK_TASK_PREFIX(), taskReq.resourceName()).amountConf()).append(" = ").append(taskReq.amount()).toString());
            }
            int resourceNumSlots = (int)Math.floor(execAmount * (long)taskReq.numParts() / (long)taskReq.amount());
            if (resourceNumSlots >= numSlots$1.elem) break block2;
            if (shouldCheckExecCores$1) {
                throw new IllegalArgumentException(new StringBuilder(301).append("The number of slots on an executor has to be limited by the number of cores, otherwise you waste resources and dynamic allocation doesn't work properly. Your configuration has ").append("core/task cpu slots = ").append(numSlots$1.elem).append(" and ").append(taskReq.resourceName()).append(" = ").append(resourceNumSlots).append(". ").append("Please adjust your configuration so that all resources require same number ").append("of executor slots.").toString());
            }
            numSlots$1.elem = resourceNumSlots;
            limitingResourceName$1.elem = taskReq.resourceName();
        }
    }

    public static final /* synthetic */ void $anonfun$createTaskScheduler$6(scala.collection.immutable.Map executorResourcesAndAmounts$1, IntRef numSlots$1, ObjectRef limitingResourceName$1, ResourceRequirement taskReq) {
        block1: {
            long execAmount = BoxesRunTime.unboxToLong((Object)executorResourcesAndAmounts$1.apply((Object)taskReq.resourceName()));
            if ((long)(numSlots$1.elem * taskReq.amount() / taskReq.numParts()) >= execAmount) break block1;
            String taskReqStr = taskReq.numParts() > 1 ? new StringBuilder(1).append(taskReq.amount()).append("/").append(taskReq.numParts()).toString() : String.valueOf(BoxesRunTime.boxToInteger((int)taskReq.amount()));
            int resourceNumSlots = (int)Math.floor(execAmount * (long)taskReq.numParts() / (long)taskReq.amount());
            String message = new StringBuilder(209).append("The configuration of resource: ").append(taskReq.resourceName()).append(" ").append("(exec = ").append(execAmount).append(", task = ").append(taskReqStr).append(", ").append("runnable tasks = ").append(resourceNumSlots).append(") will ").append("result in wasted resources due to resource ").append((String)limitingResourceName$1.elem).append(" limiting the ").append("number of runnable tasks per executor to: ").append(numSlots$1.elem).append(". Please adjust ").append("your configuration.").toString();
            if (Utils$.MODULE$.isTesting()) {
                throw new SparkException(message);
            }
            MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> message);
        }
    }

    private final void checkResourcesPerTask$1(boolean clusterMode, Option executorCores, SparkContext sc$2, String master$1) {
        Tuple2 tuple2;
        boolean shouldCheckExecCores;
        int taskCores = BoxesRunTime.unboxToInt((Object)sc$2.conf().get(package$.MODULE$.CPUS_PER_TASK()));
        int execCores = clusterMode ? BoxesRunTime.unboxToInt((Object)executorCores.getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToInt((Object)sc$2.conf().get(package$.MODULE$.EXECUTOR_CORES())))) : BoxesRunTime.unboxToInt((Object)executorCores.get());
        boolean bl = shouldCheckExecCores = executorCores.isDefined() || sc$2.conf().contains(package$.MODULE$.EXECUTOR_CORES()) || master$1.equalsIgnoreCase("yarn") || master$1.startsWith("k8s");
        if (shouldCheckExecCores && execCores < taskCores) {
            throw new SparkException(new StringBuilder(84).append("The number of cores per executor (=").append(execCores).append(") has to be >= ").append("the task config: ").append(package$.MODULE$.CPUS_PER_TASK().key()).append(" = ").append(taskCores).append(" when run on ").append(master$1).append(".").toString());
        }
        Seq<ResourceRequirement> taskResourceRequirements = ResourceUtils$.MODULE$.parseResourceRequirements(sc$2.conf(), package$.MODULE$.SPARK_TASK_PREFIX());
        scala.collection.immutable.Map executorResourcesAndAmounts = ((TraversableOnce)ResourceUtils$.MODULE$.parseAllResourceRequests(sc$2.conf(), package$.MODULE$.SPARK_EXECUTOR_PREFIX()).map((Function1 & Serializable & scala.Serializable)request -> new Tuple2((Object)request.id().resourceName(), (Object)BoxesRunTime.boxToLong((long)request.amount())), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        Tuple2 tuple22 = tuple2 = shouldCheckExecCores ? new Tuple2((Object)BoxesRunTime.boxToInteger((int)(execCores / taskCores)), (Object)"CPU") : new Tuple2((Object)BoxesRunTime.boxToInteger((int)-1), (Object)"");
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int numSlots = tuple2._1$mcI$sp();
        String limitingResourceName = (String)tuple2._2();
        Tuple2 tuple23 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)numSlots), (Object)limitingResourceName);
        Tuple2 tuple24 = tuple23;
        IntRef numSlots2 = IntRef.create((int)tuple24._1$mcI$sp());
        ObjectRef limitingResourceName2 = ObjectRef.create((Object)((String)tuple24._2()));
        taskResourceRequirements.foreach((Function1 & Serializable & scala.Serializable)taskReq -> {
            SparkContext$.$anonfun$createTaskScheduler$3(executorResourcesAndAmounts, numSlots2, shouldCheckExecCores, limitingResourceName2, taskReq);
            return BoxedUnit.UNIT;
        });
        if (!shouldCheckExecCores && Utils$.MODULE$.isDynamicAllocationEnabled(sc$2.conf())) {
            this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Please ensure that the number of slots available on your executors is limited by the number of cores to task cpus and not another custom resource. If cores is not the limiting resource then dynamic allocation will not work properly!");
        }
        taskResourceRequirements.foreach((Function1 & Serializable & scala.Serializable)taskReq -> {
            SparkContext$.$anonfun$createTaskScheduler$6(executorResourcesAndAmounts, numSlots2, limitingResourceName2, taskReq);
            return BoxedUnit.UNIT;
        });
    }

    private static final int localCpuCount$1() {
        return Runtime.getRuntime().availableProcessors();
    }

    private static final int localCpuCount$2() {
        return Runtime.getRuntime().availableProcessors();
    }

    private SparkContext$() {
        MODULE$ = this;
        Logging.$init$(this);
        this.org$apache$spark$SparkContext$$VALID_LOG_LEVELS = (Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ALL", "DEBUG", "ERROR", "FATAL", "INFO", "OFF", "TRACE", "WARN"}));
        this.SPARK_CONTEXT_CONSTRUCTOR_LOCK = new Object();
        this.org$apache$spark$SparkContext$$activeContext = new AtomicReference<Object>(null);
        this.contextBeingConstructed = None$.MODULE$;
        this.SPARK_JOB_DESCRIPTION = "spark.job.description";
        this.SPARK_JOB_GROUP_ID = "spark.jobGroup.id";
        this.SPARK_JOB_INTERRUPT_ON_CANCEL = "spark.job.interruptOnCancel";
        this.SPARK_SCHEDULER_POOL = "spark.scheduler.pool";
        this.RDD_SCOPE_KEY = "spark.rdd.scope";
        this.RDD_SCOPE_NO_OVERRIDE_KEY = "spark.rdd.scope.noOverride";
        this.DRIVER_IDENTIFIER = "driver";
    }
}

