/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark;

import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.spark.GetMapOutputStatuses;
import org.apache.spark.MapOutputTracker;
import org.apache.spark.MapOutputTracker$;
import org.apache.spark.SparkConf;
import org.apache.spark.scheduler.MapStatus;
import org.apache.spark.shuffle.MetadataFetchFailedException;
import org.apache.spark.storage.BlockId;
import org.apache.spark.storage.BlockManagerId;
import org.apache.spark.util.KeyLock;
import scala.Function0;
import scala.Predef$;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.mutable.Map;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0001\u0005%a!\u0002\u0007\u000e\u00015\u0019\u0002\u0002\u0003\r\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000e\t\u000bu\u0001A\u0011\u0001\u0010\t\u000f\u0005\u0002!\u0019!C\u0001E!1!\b\u0001Q\u0001\n\rBqa\u000f\u0001C\u0002\u0013%A\b\u0003\u0004D\u0001\u0001\u0006I!\u0010\u0005\u0006\t\u0002!\t%\u0012\u0005\u0006[\u0002!\tE\u001c\u0005\u0006m\u0002!Ia\u001e\u0005\u0006u\u0002!\ta\u001f\u0005\b\u0003\u0003\u0001A\u0011AA\u0002\u0005Yi\u0015\r](viB,H\u000f\u0016:bG.,'oV8sW\u0016\u0014(B\u0001\b\u0010\u0003\u0015\u0019\b/\u0019:l\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0014\u0005\u0001!\u0002CA\u000b\u0017\u001b\u0005i\u0011BA\f\u000e\u0005Ai\u0015\r](viB,H\u000f\u0016:bG.,'/\u0001\u0003d_:47\u0001\u0001\t\u0003+mI!\u0001H\u0007\u0003\u0013M\u0003\u0018M]6D_:4\u0017A\u0002\u001fj]&$h\b\u0006\u0002 AA\u0011Q\u0003\u0001\u0005\u00061\t\u0001\rAG\u0001\f[\u0006\u00048\u000b^1ukN,7/F\u0001$!\u0011!3&L\u0019\u000e\u0003\u0015R!AJ\u0014\u0002\u000f5,H/\u00192mK*\u0011\u0001&K\u0001\u000bG>dG.Z2uS>t'\"\u0001\u0016\u0002\u000bM\u001c\u0017\r\\1\n\u00051*#aA'baB\u0011afL\u0007\u0002S%\u0011\u0001'\u000b\u0002\u0004\u0013:$\bc\u0001\u00183i%\u00111'\u000b\u0002\u0006\u0003J\u0014\u0018-\u001f\t\u0003kaj\u0011A\u000e\u0006\u0003o5\t\u0011b]2iK\u0012,H.\u001a:\n\u0005e2$!C'baN#\u0018\r^;t\u00031i\u0017\r]*uCR,8/Z:!\u000311W\r^2iS:<Gj\\2l+\u0005i\u0004c\u0001 B[5\tqH\u0003\u0002A\u001b\u0005!Q\u000f^5m\u0013\t\u0011uHA\u0004LKfdunY6\u0002\u001b\u0019,Go\u00195j]\u001edunY6!\u0003]9W\r^'baNK'0Z:Cs\u0016CXmY;u_JLE\r\u0006\u0003GO&\\\u0007cA$P%:\u0011\u0001*\u0014\b\u0003\u00132k\u0011A\u0013\u0006\u0003\u0017f\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0016\n\u00059K\u0013a\u00029bG.\fw-Z\u0005\u0003!F\u0013\u0001\"\u0013;fe\u0006$xN\u001d\u0006\u0003\u001d&\u0002BAL*V7&\u0011A+\u000b\u0002\u0007)V\u0004H.\u001a\u001a\u0011\u0005YKV\"A,\u000b\u0005ak\u0011aB:u_J\fw-Z\u0005\u00035^\u0013aB\u00117pG.l\u0015M\\1hKJLE\rE\u0002H9zK!!X)\u0003\u0007M+\u0017\u000fE\u0003/?\u0006$W&\u0003\u0002aS\t1A+\u001e9mKN\u0002\"A\u00162\n\u0005\r<&a\u0002\"m_\u000e\\\u0017\n\u001a\t\u0003]\u0015L!AZ\u0015\u0003\t1{gn\u001a\u0005\u0006Q\u001e\u0001\r!L\u0001\ng\",hM\u001a7f\u0013\u0012DQA[\u0004A\u00025\nab\u001d;beR\u0004\u0016M\u001d;ji&|g\u000eC\u0003m\u000f\u0001\u0007Q&\u0001\u0007f]\u0012\u0004\u0016M\u001d;ji&|g.\u0001\nhKRl\u0015\r]*ju\u0016\u001c()\u001f*b]\u001e,GC\u0002$paJ$X\u000fC\u0003i\u0011\u0001\u0007Q\u0006C\u0003r\u0011\u0001\u0007Q&A\u0007ti\u0006\u0014H/T1q\u0013:$W\r\u001f\u0005\u0006g\"\u0001\r!L\u0001\fK:$W*\u00199J]\u0012,\u0007\u0010C\u0003k\u0011\u0001\u0007Q\u0006C\u0003m\u0011\u0001\u0007Q&A\u0006hKR\u001cF/\u0019;vg\u0016\u001cHcA\u0019ys\")\u0001.\u0003a\u0001[!)\u0001$\u0003a\u00015\u0005\tRO\u001c:fO&\u001cH/\u001a:TQV4g\r\\3\u0015\u0005q|\bC\u0001\u0018~\u0013\tq\u0018F\u0001\u0003V]&$\b\"\u00025\u000b\u0001\u0004i\u0013aC;qI\u0006$X-\u00129pG\"$2\u0001`A\u0003\u0011\u0019\t9a\u0003a\u0001I\u0006Aa.Z<Fa>\u001c\u0007\u000e")
public class MapOutputTrackerWorker
extends MapOutputTracker {
    private final SparkConf conf;
    private final Map<Object, MapStatus[]> mapStatuses;
    private final KeyLock<Object> fetchingLock;

    public Map<Object, MapStatus[]> mapStatuses() {
        return this.mapStatuses;
    }

    private KeyLock<Object> fetchingLock() {
        return this.fetchingLock;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesByExecutorId(int shuffleId, int startPartition, int endPartition) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(43).append("Fetching outputs for shuffle ").append(shuffleId).append(", partitions ").append(startPartition).append("-").append(endPartition).toString());
        MapStatus[] statuses = this.getStatuses(shuffleId, this.conf);
        try {
            iterator = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, statuses, 0, statuses.length);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            throw e;
        }
        return iterator;
    }

    @Override
    public Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> getMapSizesByRange(int shuffleId, int startMapIndex, int endMapIndex, int startPartition, int endPartition) {
        Iterator<Tuple2<BlockManagerId, Seq<Tuple3<BlockId, Object, Object>>>> iterator;
        this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(52).append("Fetching outputs for shuffle ").append(shuffleId).append(", mappers ").append(startMapIndex).append("-").append(endMapIndex).append("partitions ").append(startPartition).append("-").append(endPartition).toString());
        MapStatus[] statuses = this.getStatuses(shuffleId, this.conf);
        try {
            iterator = MapOutputTracker$.MODULE$.convertMapStatuses(shuffleId, startPartition, endPartition, statuses, startMapIndex, endMapIndex);
        }
        catch (MetadataFetchFailedException e) {
            this.mapStatuses().clear();
            throw e;
        }
        return iterator;
    }

    /*
     * WARNING - void declaration
     */
    private MapStatus[] getStatuses(int shuffleId, SparkConf conf) {
        MapStatus[] mapStatusArray;
        MapStatus[] statuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
        if (statuses == null) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Don't have map outputs for shuffle ").append(shuffleId).append(", fetching them").toString());
            long startTimeNs = System.nanoTime();
            mapStatusArray = (MapStatus[])this.fetchingLock().withLock(BoxesRunTime.boxToInteger((int)shuffleId), (Function0 & Serializable & scala.Serializable)() -> {
                BoxedUnit boxedUnit;
                MapStatus[] fetchedStatuses = (MapStatus[])this.mapStatuses().get((Object)BoxesRunTime.boxToInteger((int)shuffleId)).orNull(Predef$.MODULE$.$conforms());
                if (fetchedStatuses == null) {
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(36).append("Doing the fetch; tracker endpoint = ").append(this.trackerEndpoint()).toString());
                    byte[] fetchedBytes = (byte[])this.askTracker(new GetMapOutputStatuses(shuffleId), ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)));
                    fetchedStatuses = MapOutputTracker$.MODULE$.deserializeMapStatuses(fetchedBytes, conf);
                    this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Got the output locations");
                    boxedUnit = this.mapStatuses().put((Object)BoxesRunTime.boxToInteger((int)shuffleId), (Object)fetchedStatuses);
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                this.logDebug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(50).append("Fetching map output statuses for shuffle ").append(shuffleId).append(" took ").append(TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTimeNs)).append(" ms").toString());
                return fetchedStatuses;
            });
        } else {
            void var3_3;
            mapStatusArray = var3_3;
        }
        return mapStatusArray;
    }

    @Override
    public void unregisterShuffle(int shuffleId) {
        this.mapStatuses().remove((Object)BoxesRunTime.boxToInteger((int)shuffleId));
    }

    public void updateEpoch(long newEpoch) {
        Object object = this.epochLock();
        synchronized (object) {
            if (newEpoch > this.epoch()) {
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Updating epoch to ").append(newEpoch).append(" and clearing cache").toString());
                this.epoch_$eq(newEpoch);
                this.mapStatuses().clear();
            }
        }
    }

    public MapOutputTrackerWorker(SparkConf conf) {
        this.conf = conf;
        super(conf);
        this.mapStatuses = (Map)JavaConverters$.MODULE$.mapAsScalaConcurrentMapConverter(new ConcurrentHashMap()).asScala();
        this.fetchingLock = new KeyLock();
    }
}

