/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.groovy.control;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import org.apache.groovy.ast.tools.ClassNodeUtils;
import org.codehaus.groovy.ast.ClassCodeVisitorSupport;
import org.codehaus.groovy.ast.ClassNode;
import org.codehaus.groovy.ast.CodeVisitorSupport;
import org.codehaus.groovy.ast.DynamicVariable;
import org.codehaus.groovy.ast.FieldNode;
import org.codehaus.groovy.ast.MethodNode;
import org.codehaus.groovy.ast.Parameter;
import org.codehaus.groovy.ast.Variable;
import org.codehaus.groovy.ast.expr.ClosureExpression;
import org.codehaus.groovy.ast.expr.ConstructorCallExpression;
import org.codehaus.groovy.ast.expr.Expression;
import org.codehaus.groovy.ast.expr.MethodCallExpression;
import org.codehaus.groovy.ast.expr.PropertyExpression;
import org.codehaus.groovy.ast.expr.VariableExpression;
import org.codehaus.groovy.control.SourceUnit;

public class StaticVerifier
extends ClassCodeVisitorSupport {
    private boolean inClosure;
    private boolean inSpecialConstructorCall;
    private MethodNode methodNode;
    private SourceUnit sourceUnit;

    @Override
    protected SourceUnit getSourceUnit() {
        return this.sourceUnit;
    }

    public void visitClass(ClassNode node, SourceUnit unit) {
        this.sourceUnit = unit;
        this.visitClass(node);
    }

    @Override
    public void visitClosureExpression(ClosureExpression ce) {
        boolean oldInClosure = this.inClosure;
        this.inClosure = true;
        super.visitClosureExpression(ce);
        this.inClosure = oldInClosure;
    }

    @Override
    public void visitConstructorCallExpression(ConstructorCallExpression cce) {
        boolean oldIsSpecialConstructorCall = this.inSpecialConstructorCall;
        this.inSpecialConstructorCall = cce.isSpecialCall();
        super.visitConstructorCallExpression(cce);
        this.inSpecialConstructorCall = oldIsSpecialConstructorCall;
    }

    @Override
    public void visitConstructorOrMethod(MethodNode node, boolean isConstructor) {
        MethodNode oldMethodNode = this.methodNode;
        this.methodNode = node;
        super.visitConstructorOrMethod(node, isConstructor);
        if (isConstructor) {
            final HashSet<String> exceptions = new HashSet<String>();
            for (final Parameter param : node.getParameters()) {
                exceptions.add(param.getName());
                if (!param.hasInitialExpression()) continue;
                param.getInitialExpression().visit(new CodeVisitorSupport(){

                    @Override
                    public void visitVariableExpression(VariableExpression ve) {
                        if (exceptions.contains(ve.getName())) {
                            return;
                        }
                        if (ve.getAccessedVariable() instanceof DynamicVariable || !ve.isInStaticContext()) {
                            StaticVerifier.this.addVariableError(ve);
                        }
                    }

                    @Override
                    public void visitMethodCallExpression(MethodCallExpression call) {
                        VariableExpression ve;
                        Expression objectExpression = call.getObjectExpression();
                        if (objectExpression instanceof VariableExpression && (ve = (VariableExpression)objectExpression).isThisExpression()) {
                            StaticVerifier.this.addError("Can't access instance method '" + call.getMethodAsString() + "' for a constructor parameter default value", param);
                            return;
                        }
                        super.visitMethodCallExpression(call);
                    }

                    @Override
                    public void visitClosureExpression(ClosureExpression expression) {
                    }
                });
            }
        }
        this.methodNode = oldMethodNode;
    }

    @Override
    public void visitMethodCallExpression(MethodCallExpression mce) {
        VariableExpression ve;
        Expression objectExpression;
        if (this.inSpecialConstructorCall && !ClassNodeUtils.isInnerClass(this.methodNode.getDeclaringClass()) && (objectExpression = mce.getObjectExpression()) instanceof VariableExpression && (ve = (VariableExpression)objectExpression).isThisExpression()) {
            this.addError("Can't access instance method '" + mce.getMethodAsString() + "' before the class is constructed", mce);
            return;
        }
        super.visitMethodCallExpression(mce);
    }

    @Override
    public void visitPropertyExpression(PropertyExpression pe) {
        if (!this.inClosure && !this.inSpecialConstructorCall) {
            for (Expression it = pe; it != null; it = it.getObjectExpression()) {
                if (it instanceof PropertyExpression) continue;
                if (it instanceof VariableExpression) {
                    FieldNode fieldNode;
                    VariableExpression ve = (VariableExpression)it;
                    if (ve.isThisExpression() || ve.isSuperExpression()) {
                        return;
                    }
                    if (!(this.inSpecialConstructorCall || !this.inClosure && ve.isInStaticContext())) {
                        return;
                    }
                    if (this.methodNode != null && this.methodNode.isStatic() && (fieldNode = StaticVerifier.getDeclaredOrInheritedField(this.methodNode.getDeclaringClass(), ve.getName())) != null && fieldNode.isStatic()) {
                        return;
                    }
                    Variable v = ve.getAccessedVariable();
                    if (v != null && !(v instanceof DynamicVariable) && v.isInStaticContext()) {
                        return;
                    }
                    this.addVariableError(ve);
                }
                return;
            }
        }
    }

    @Override
    public void visitVariableExpression(VariableExpression ve) {
        if (ve.getAccessedVariable() instanceof DynamicVariable && (ve.isInStaticContext() || this.inSpecialConstructorCall) && !this.inClosure) {
            FieldNode fieldNode;
            if (this.methodNode != null && this.methodNode.isStatic() && (fieldNode = StaticVerifier.getDeclaredOrInheritedField(this.methodNode.getDeclaringClass(), ve.getName())) != null && fieldNode.isStatic()) {
                return;
            }
            this.addVariableError(ve);
        }
    }

    private void addVariableError(VariableExpression ve) {
        this.addError("Apparent variable '" + ve.getName() + "' was found in a static scope but doesn't refer to a local variable, static field or class. Possible causes:\nYou attempted to reference a variable in the binding or an instance variable from a static context.\nYou misspelled a classname or statically imported field. Please check the spelling.\nYou attempted to use a method '" + ve.getName() + "' but left out brackets in a place not allowed by the grammar.", ve);
    }

    private static FieldNode getDeclaredOrInheritedField(ClassNode cn, String fieldName) {
        for (ClassNode node = cn; node != null; node = node.getSuperClass()) {
            FieldNode fn = node.getDeclaredField(fieldName);
            if (fn != null) {
                return fn;
            }
            ArrayList<ClassNode> interfacesToCheck = new ArrayList<ClassNode>(Arrays.asList(node.getInterfaces()));
            while (!interfacesToCheck.isEmpty()) {
                ClassNode nextInterface = (ClassNode)interfacesToCheck.remove(0);
                fn = nextInterface.getDeclaredField(fieldName);
                if (fn != null) {
                    return fn;
                }
                interfacesToCheck.addAll(Arrays.asList(nextInterface.getInterfaces()));
            }
        }
        return null;
    }
}

