/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.network.util;

import io.netty.buffer.PooledByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.ServerChannel;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollServerSocketChannel;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.DefaultThreadFactory;
import io.netty.util.internal.PlatformDependent;
import java.util.concurrent.ThreadFactory;
import org.apache.spark.network.util.IOMode;
import org.apache.spark.network.util.TransportFrameDecoder;

public class NettyUtils {
    private static int MAX_DEFAULT_NETTY_THREADS = 8;
    private static final PooledByteBufAllocator[] _sharedPooledByteBufAllocator = new PooledByteBufAllocator[2];

    public static ThreadFactory createThreadFactory(String threadPoolPrefix) {
        return new DefaultThreadFactory(threadPoolPrefix, true);
    }

    public static EventLoopGroup createEventLoop(IOMode mode, int numThreads, String threadPrefix) {
        ThreadFactory threadFactory = NettyUtils.createThreadFactory(threadPrefix);
        switch (mode) {
            case NIO: {
                return new NioEventLoopGroup(numThreads, threadFactory);
            }
            case EPOLL: {
                return new EpollEventLoopGroup(numThreads, threadFactory);
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends Channel> getClientChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioSocketChannel.class;
            }
            case EPOLL: {
                return EpollSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static Class<? extends ServerChannel> getServerChannelClass(IOMode mode) {
        switch (mode) {
            case NIO: {
                return NioServerSocketChannel.class;
            }
            case EPOLL: {
                return EpollServerSocketChannel.class;
            }
        }
        throw new IllegalArgumentException("Unknown io mode: " + (Object)((Object)mode));
    }

    public static TransportFrameDecoder createFrameDecoder() {
        return new TransportFrameDecoder();
    }

    public static String getRemoteAddress(Channel channel) {
        if (channel != null && channel.remoteAddress() != null) {
            return channel.remoteAddress().toString();
        }
        return "<unknown remote>";
    }

    public static int defaultNumThreads(int numUsableCores) {
        int availableCores = numUsableCores > 0 ? numUsableCores : Runtime.getRuntime().availableProcessors();
        return Math.min(availableCores, MAX_DEFAULT_NETTY_THREADS);
    }

    public static synchronized PooledByteBufAllocator getSharedPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache) {
        int index;
        int n = index = allowCache ? 0 : 1;
        if (_sharedPooledByteBufAllocator[index] == null) {
            NettyUtils._sharedPooledByteBufAllocator[index] = NettyUtils.createPooledByteBufAllocator(allowDirectBufs, allowCache, NettyUtils.defaultNumThreads(0));
        }
        return _sharedPooledByteBufAllocator[index];
    }

    public static PooledByteBufAllocator createPooledByteBufAllocator(boolean allowDirectBufs, boolean allowCache, int numCores) {
        if (numCores == 0) {
            numCores = Runtime.getRuntime().availableProcessors();
        }
        return new PooledByteBufAllocator(allowDirectBufs && PlatformDependent.directBufferPreferred(), Math.min(PooledByteBufAllocator.defaultNumHeapArena(), numCores), Math.min(PooledByteBufAllocator.defaultNumDirectArena(), allowDirectBufs ? numCores : 0), PooledByteBufAllocator.defaultPageSize(), PooledByteBufAllocator.defaultMaxOrder(), allowCache ? PooledByteBufAllocator.defaultTinyCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultSmallCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultNormalCacheSize() : 0, allowCache ? PooledByteBufAllocator.defaultUseCacheForAllThreads() : false);
    }
}

