/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.hbase;

import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.client.Connection;
import org.janusgraph.diskstorage.hbase.AdminMask;
import org.janusgraph.diskstorage.hbase.ConnectionMask;
import org.janusgraph.diskstorage.hbase.HBaseAdmin1_0;
import org.janusgraph.diskstorage.hbase.HTable1_0;
import org.janusgraph.diskstorage.hbase.TableMask;

public class HConnection1_0
implements ConnectionMask {
    private final Connection cnx;

    public HConnection1_0(Connection cnx) {
        this.cnx = cnx;
    }

    @Override
    public TableMask getTable(String name) throws IOException {
        return new HTable1_0(this.cnx.getTable(TableName.valueOf((String)name)));
    }

    @Override
    public AdminMask getAdmin() throws IOException {
        return new HBaseAdmin1_0(this.cnx.getAdmin());
    }

    @Override
    public void close() throws IOException {
        this.cnx.close();
    }

    @Override
    public List<HRegionLocation> getRegionLocations(String tableName) throws IOException {
        return this.cnx.getRegionLocator(TableName.valueOf((String)tableName)).getAllRegionLocations();
    }
}

