/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.spark.structure.io;

import org.apache.commons.configuration2.Configuration;
import org.apache.spark.api.java.JavaPairRDD;
import org.apache.spark.api.java.JavaSparkContext;
import org.apache.tinkerpop.gremlin.hadoop.structure.io.VertexWritable;
import org.apache.tinkerpop.gremlin.hadoop.structure.util.ConfUtil;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputFormatRDD;
import org.apache.tinkerpop.gremlin.spark.structure.io.InputRDD;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SparkIOUtil {
    private static final Logger logger = LoggerFactory.getLogger(SparkIOUtil.class);

    public static JavaPairRDD<Object, VertexWritable> loadVertices(Configuration sparkGraphConfiguration, JavaSparkContext sparkContext) {
        assert (sparkGraphConfiguration.containsKey("gremlin.hadoop.graphReader"));
        logger.debug("Loading vertices into Spark RDD...");
        org.apache.hadoop.conf.Configuration hadoopConfiguration = ConfUtil.makeHadoopConfiguration((Configuration)sparkGraphConfiguration);
        return SparkIOUtil.loadVertices(SparkIOUtil.createInputRDD(hadoopConfiguration), sparkGraphConfiguration, sparkContext);
    }

    public static JavaPairRDD<Object, VertexWritable> loadVertices(InputRDD inputRDD, Configuration sparkGraphConfiguration, JavaSparkContext sparkContext) {
        JavaPairRDD<Object, VertexWritable> loadedGraphRDD = inputRDD.readGraphRDD(sparkGraphConfiguration, sparkContext);
        return loadedGraphRDD;
    }

    public static InputRDD createInputRDD(org.apache.hadoop.conf.Configuration hadoopConfiguration) {
        InputRDD inputRDD;
        try {
            inputRDD = InputRDD.class.isAssignableFrom(hadoopConfiguration.getClass("gremlin.hadoop.graphReader", Object.class)) ? (InputRDD)hadoopConfiguration.getClass("gremlin.hadoop.graphReader", InputRDD.class, InputRDD.class).newInstance() : (InputRDD)InputFormatRDD.class.newInstance();
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
        return inputRDD;
    }
}

