/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.server.handler;

import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpMessage;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.HashMap;
import org.apache.tinkerpop.gremlin.server.Settings;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticatedUser;
import org.apache.tinkerpop.gremlin.server.auth.AuthenticationException;
import org.apache.tinkerpop.gremlin.server.auth.Authenticator;
import org.apache.tinkerpop.gremlin.server.authz.Authorizer;
import org.apache.tinkerpop.gremlin.server.handler.AbstractAuthenticationHandler;
import org.apache.tinkerpop.gremlin.server.handler.StateKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpBasicAuthenticationHandler
extends AbstractAuthenticationHandler {
    private static final Logger logger = LoggerFactory.getLogger(HttpBasicAuthenticationHandler.class);
    private static final Logger auditLogger = LoggerFactory.getLogger((String)"audit.org.apache.tinkerpop.gremlin.server");
    private final Settings settings;
    private final Base64.Decoder decoder = Base64.getUrlDecoder();

    @Deprecated
    public HttpBasicAuthenticationHandler(Authenticator authenticator, Settings settings) {
        this(authenticator, null, settings);
    }

    public HttpBasicAuthenticationHandler(Authenticator authenticator, Authorizer authorizer, Settings settings) {
        super(authenticator, authorizer);
        this.settings = settings;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        if (msg instanceof FullHttpMessage) {
            FullHttpMessage request = (FullHttpMessage)msg;
            if (!request.headers().contains("Authorization")) {
                this.sendError(ctx, msg);
                return;
            }
            String basic = "Basic ";
            String authorizationHeader = request.headers().get("Authorization");
            if (!authorizationHeader.startsWith("Basic ")) {
                this.sendError(ctx, msg);
                return;
            }
            byte[] decodedUserPass = null;
            try {
                String encodedUserPass = authorizationHeader.substring("Basic ".length());
                decodedUserPass = this.decoder.decode(encodedUserPass);
            }
            catch (IndexOutOfBoundsException iae) {
                this.sendError(ctx, msg);
                return;
            }
            catch (IllegalArgumentException iae) {
                this.sendError(ctx, msg);
                return;
            }
            String authorization = new String(decodedUserPass, Charset.forName("UTF-8"));
            String[] split = authorization.split(":");
            if (split.length != 2) {
                this.sendError(ctx, msg);
                return;
            }
            HashMap<String, String> credentials = new HashMap<String, String>();
            credentials.put("username", split[0]);
            credentials.put("password", split[1]);
            String address = ctx.channel().remoteAddress().toString();
            if (address.startsWith("/") && address.length() > 1) {
                address = address.substring(1);
            }
            credentials.put("address", address);
            try {
                AuthenticatedUser user = this.authenticator.authenticate(credentials);
                ctx.channel().attr(StateKey.AUTHENTICATED_USER).set((Object)user);
                ctx.fireChannelRead((Object)request);
                if (this.settings.enableAuditLog.booleanValue() || this.settings.authentication.enableAuditLog) {
                    String[] authClassParts = this.authenticator.getClass().toString().split("[.]");
                    auditLogger.info("User {} with address {} authenticated by {}", new Object[]{credentials.get("username"), address, authClassParts[authClassParts.length - 1]});
                }
            }
            catch (AuthenticationException ae) {
                this.sendError(ctx, msg);
            }
        }
    }

    private void sendError(ChannelHandlerContext ctx, Object msg) {
        ctx.writeAndFlush((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.UNAUTHORIZED)).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        ReferenceCountUtil.release((Object)msg);
    }
}

