/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.querymatcher;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.PrivateCellUtil;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnCount;
import org.apache.hadoop.hbase.regionserver.querymatcher.ColumnTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.querymatcher.ScanQueryMatcher;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class NewVersionBehaviorTracker
implements ColumnTracker,
DeleteTracker {
    private byte[] lastCqArray;
    private int lastCqLength;
    private int lastCqOffset;
    private long lastCqTs;
    private long lastCqMvcc;
    private byte lastCqType;
    private int columnIndex;
    private int countCurrentCol;
    protected int maxVersions;
    private int resultMaxVersions;
    private byte[][] columns;
    private int minVersions;
    private long oldestStamp;
    private CellComparator comparator;
    protected NavigableMap<Long, DeleteVersionsNode> delColMap = new TreeMap<Long, DeleteVersionsNode>();
    protected NavigableMap<Long, DeleteVersionsNode> delFamMap = new TreeMap<Long, DeleteVersionsNode>();

    public NewVersionBehaviorTracker(NavigableSet<byte[]> columns, CellComparator comparartor, int minVersion, int maxVersion, int resultMaxVersions, long oldestUnexpiredTS) {
        this.maxVersions = maxVersion;
        this.minVersions = minVersion;
        this.resultMaxVersions = resultMaxVersions;
        this.oldestStamp = oldestUnexpiredTS;
        if (columns != null && columns.size() > 0) {
            this.columns = new byte[columns.size()][];
            int i = 0;
            for (byte[] column : columns) {
                this.columns[i++] = column;
            }
        }
        this.comparator = comparartor;
        this.reset();
    }

    @Override
    public void beforeShipped() throws IOException {
    }

    protected long prepare(Cell cell) {
        boolean matchCq = PrivateCellUtil.matchingQualifier(cell, this.lastCqArray, this.lastCqOffset, this.lastCqLength);
        if (!matchCq) {
            this.delColMap.clear();
            for (Map.Entry e : this.delFamMap.entrySet()) {
                this.delColMap.put((Long)e.getKey(), ((DeleteVersionsNode)e.getValue()).getDeepCopy());
            }
            this.countCurrentCol = 0;
        }
        if (matchCq && !PrivateCellUtil.isDelete(this.lastCqType) && this.lastCqType == cell.getTypeByte() && this.lastCqTs == cell.getTimestamp()) {
            return this.lastCqMvcc;
        }
        this.lastCqArray = cell.getQualifierArray();
        this.lastCqOffset = cell.getQualifierOffset();
        this.lastCqLength = cell.getQualifierLength();
        this.lastCqTs = cell.getTimestamp();
        this.lastCqMvcc = cell.getSequenceId();
        this.lastCqType = cell.getTypeByte();
        return Long.MAX_VALUE;
    }

    @Override
    public void add(Cell cell) {
        this.prepare(cell);
        byte type = cell.getTypeByte();
        switch (KeyValue.Type.codeToType(type)) {
            case DeleteFamily: {
                this.delFamMap.put(cell.getSequenceId(), new DeleteVersionsNode(cell.getTimestamp(), cell.getSequenceId()));
                break;
            }
            case DeleteFamilyVersion: {
                this.delFamMap.ceilingEntry(cell.getSequenceId()).getValue().addVersionDelete(cell);
                break;
            }
            case DeleteColumn: {
                this.delColMap.put(cell.getSequenceId(), new DeleteVersionsNode(cell.getTimestamp(), cell.getSequenceId()));
                break;
            }
            case Delete: {
                this.delColMap.ceilingEntry(cell.getSequenceId()).getValue().addVersionDelete(cell);
                break;
            }
            default: {
                throw new AssertionError((Object)("Unknown delete marker type for " + cell));
            }
        }
    }

    @Override
    public DeleteTracker.DeleteResult isDeleted(Cell cell) {
        long duplicateMvcc = this.prepare(cell);
        for (Map.Entry<Long, DeleteVersionsNode> e : this.delColMap.tailMap(cell.getSequenceId()).entrySet()) {
            SortedSet<Long> tail;
            DeleteVersionsNode node = e.getValue();
            long deleteMvcc = Long.MAX_VALUE;
            SortedSet deleteVersionMvccs = (SortedSet)node.deletesMap.get(cell.getTimestamp());
            if (deleteVersionMvccs != null && !(tail = deleteVersionMvccs.tailSet(cell.getSequenceId())).isEmpty()) {
                deleteMvcc = tail.first();
            }
            NavigableMap subMap = node.mvccCountingMap.subMap(cell.getSequenceId(), true, Math.min(duplicateMvcc, deleteMvcc), true);
            for (Map.Entry seg : subMap.entrySet()) {
                if (((SortedSet)seg.getValue()).size() >= this.maxVersions) {
                    return DeleteTracker.DeleteResult.VERSION_MASKED;
                }
                ((SortedSet)seg.getValue()).add(cell.getSequenceId());
            }
            if (deleteMvcc < Long.MAX_VALUE) {
                return DeleteTracker.DeleteResult.VERSION_DELETED;
            }
            if (cell.getTimestamp() > node.ts) continue;
            return DeleteTracker.DeleteResult.COLUMN_DELETED;
        }
        if (duplicateMvcc < Long.MAX_VALUE) {
            return DeleteTracker.DeleteResult.VERSION_MASKED;
        }
        return DeleteTracker.DeleteResult.NOT_DELETED;
    }

    @Override
    public boolean isEmpty() {
        return this.delColMap.size() == 1 && ((DeleteVersionsNode)this.delColMap.get(Long.MAX_VALUE)).mvccCountingMap.size() == 1 && this.delFamMap.size() == 1 && ((DeleteVersionsNode)this.delFamMap.get(Long.MAX_VALUE)).mvccCountingMap.size() == 1;
    }

    @Override
    public void update() {
    }

    @Override
    public ScanQueryMatcher.MatchCode checkColumn(Cell cell, byte type) throws IOException {
        if (this.columns == null) {
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        while (!this.done()) {
            int c = CellUtil.compareQualifiers(cell, this.columns[this.columnIndex], 0, this.columns[this.columnIndex].length);
            if (c < 0) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
            if (c == 0) {
                return ScanQueryMatcher.MatchCode.INCLUDE;
            }
            ++this.columnIndex;
        }
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_ROW;
    }

    @Override
    public ScanQueryMatcher.MatchCode checkVersions(Cell cell, long timestamp, byte type, boolean ignoreCount) throws IOException {
        assert (!PrivateCellUtil.isDelete(type));
        if (ignoreCount) {
            return ScanQueryMatcher.MatchCode.INCLUDE;
        }
        ++this.countCurrentCol;
        if (timestamp < this.oldestStamp) {
            if (this.countCurrentCol == this.minVersions) {
                return ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL;
            }
            if (this.countCurrentCol > this.minVersions) {
                return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
            }
        }
        if (this.countCurrentCol == this.resultMaxVersions) {
            return ScanQueryMatcher.MatchCode.INCLUDE_AND_SEEK_NEXT_COL;
        }
        if (this.countCurrentCol > this.resultMaxVersions) {
            return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
        }
        return ScanQueryMatcher.MatchCode.INCLUDE;
    }

    @Override
    public void reset() {
        this.delColMap.clear();
        this.delFamMap.clear();
        this.lastCqArray = null;
        this.lastCqLength = 0;
        this.lastCqOffset = 0;
        this.lastCqTs = Long.MIN_VALUE;
        this.lastCqMvcc = 0L;
        this.lastCqType = 0;
        this.columnIndex = 0;
        this.countCurrentCol = 0;
        this.resetInternal();
    }

    protected void resetInternal() {
        this.delFamMap.put(Long.MAX_VALUE, new DeleteVersionsNode());
    }

    @Override
    public boolean done() {
        return this.columns != null && this.columnIndex >= this.columns.length;
    }

    @Override
    public ColumnCount getColumnHint() {
        if (this.columns != null && this.columnIndex < this.columns.length) {
            return new ColumnCount(this.columns[this.columnIndex]);
        }
        return null;
    }

    @Override
    public ScanQueryMatcher.MatchCode getNextRowOrNextColumn(Cell cell) {
        return ScanQueryMatcher.MatchCode.SEEK_NEXT_COL;
    }

    @Override
    public boolean isDone(long timestamp) {
        return false;
    }

    @Override
    public CellComparator getCellComparator() {
        return this.comparator;
    }

    protected class DeleteVersionsNode {
        public long ts;
        public long mvcc;
        private Map<Long, SortedSet<Long>> deletesMap = new HashMap<Long, SortedSet<Long>>();
        private NavigableMap<Long, SortedSet<Long>> mvccCountingMap = new TreeMap<Long, SortedSet<Long>>();

        protected DeleteVersionsNode(long ts, long mvcc) {
            this.ts = ts;
            this.mvcc = mvcc;
            this.mvccCountingMap.put(Long.MAX_VALUE, new TreeSet());
        }

        protected DeleteVersionsNode() {
            this(Long.MIN_VALUE, Long.MAX_VALUE);
        }

        public void addVersionDelete(Cell cell) {
            SortedSet<Long> set = this.deletesMap.get(cell.getTimestamp());
            if (set == null) {
                set = new TreeSet<Long>();
                this.deletesMap.put(cell.getTimestamp(), set);
            }
            set.add(cell.getSequenceId());
            SortedSet<Long> nextValue = this.mvccCountingMap.ceilingEntry(cell.getSequenceId()).getValue();
            TreeSet<Long> thisValue = new TreeSet<Long>(nextValue.headSet(cell.getSequenceId()));
            this.mvccCountingMap.put(cell.getSequenceId(), thisValue);
        }

        protected DeleteVersionsNode getDeepCopy() {
            DeleteVersionsNode node = new DeleteVersionsNode(this.ts, this.mvcc);
            for (Map.Entry<Long, SortedSet<Long>> entry : this.deletesMap.entrySet()) {
                node.deletesMap.put(entry.getKey(), new TreeSet<Long>(entry.getValue()));
            }
            for (Map.Entry<Long, SortedSet<Long>> entry : this.mvccCountingMap.entrySet()) {
                node.mvccCountingMap.put(entry.getKey(), new TreeSet<Long>(entry.getValue()));
            }
            return node;
        }
    }
}

