/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.master.procedure;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.conf.ConfigurationObserver;
import org.apache.hadoop.hbase.ipc.RpcServer;
import org.apache.hadoop.hbase.master.MasterCoprocessorHost;
import org.apache.hadoop.hbase.master.MasterFileSystem;
import org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hadoop.hbase.master.assignment.AssignmentManager;
import org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hadoop.hbase.master.procedure.RSProcedureDispatcher;
import org.apache.hadoop.hbase.master.replication.ReplicationPeerManager;
import org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hadoop.hbase.procedure2.store.wal.WALProcedureStore;
import org.apache.hadoop.hbase.security.Superusers;
import org.apache.hadoop.hbase.security.User;
import org.apache.hadoop.hbase.util.CancelableProgressable;
import org.apache.hadoop.hbase.util.FSUtils;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.yetus.audience.InterfaceStability;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
@InterfaceStability.Evolving
public class MasterProcedureEnv
implements ConfigurationObserver {
    private static final Logger LOG = LoggerFactory.getLogger(MasterProcedureEnv.class);
    private final RSProcedureDispatcher remoteDispatcher;
    private final MasterProcedureScheduler procSched;
    private final MasterServices master;

    public MasterProcedureEnv(MasterServices master) {
        this(master, new RSProcedureDispatcher(master));
    }

    public MasterProcedureEnv(MasterServices master, RSProcedureDispatcher remoteDispatcher) {
        this.master = master;
        this.procSched = new MasterProcedureScheduler(procId -> master.getMasterProcedureExecutor().getProcedure((long)procId));
        this.remoteDispatcher = remoteDispatcher;
    }

    public User getRequestUser() {
        return RpcServer.getRequestUser().orElse(Superusers.getSystemUser());
    }

    public MasterServices getMasterServices() {
        return this.master;
    }

    public Configuration getMasterConfiguration() {
        return this.master.getConfiguration();
    }

    public AssignmentManager getAssignmentManager() {
        return this.master.getAssignmentManager();
    }

    public MasterCoprocessorHost getMasterCoprocessorHost() {
        return this.master.getMasterCoprocessorHost();
    }

    public MasterProcedureScheduler getProcedureScheduler() {
        return this.procSched;
    }

    public RSProcedureDispatcher getRemoteDispatcher() {
        return this.remoteDispatcher;
    }

    public ReplicationPeerManager getReplicationPeerManager() {
        return this.master.getReplicationPeerManager();
    }

    public MasterFileSystem getMasterFileSystem() {
        return this.master.getMasterFileSystem();
    }

    public boolean isRunning() {
        if (this.master == null || this.master.getMasterProcedureExecutor() == null) {
            return false;
        }
        return this.master.getMasterProcedureExecutor().isRunning();
    }

    public boolean isInitialized() {
        return this.master.isInitialized();
    }

    public boolean waitInitialized(Procedure<?> proc) {
        return this.master.getInitializedEvent().suspendIfNotReady(proc);
    }

    public void setEventReady(ProcedureEvent<?> event, boolean isReady) {
        if (isReady) {
            event.wake(this.procSched);
        } else {
            event.suspend();
        }
    }

    @Override
    public void onConfigurationChange(Configuration conf) {
        this.master.getMasterProcedureExecutor().refreshConfiguration(conf);
    }

    @InterfaceAudience.Private
    public static class WALStoreLeaseRecovery
    implements WALProcedureStore.LeaseRecovery {
        private final MasterServices master;

        public WALStoreLeaseRecovery(MasterServices master) {
            this.master = master;
        }

        @Override
        public void recoverFileLease(FileSystem fs, final Path path) throws IOException {
            Configuration conf = this.master.getConfiguration();
            FSUtils fsUtils = FSUtils.getInstance(fs, conf);
            fsUtils.recoverFileLease(fs, path, conf, new CancelableProgressable(){

                @Override
                public boolean progress() {
                    LOG.debug("Recover Procedure Store log lease: " + path);
                    return this.isRunning();
                }
            });
        }

        private boolean isRunning() {
            return !this.master.isStopped() && !this.master.isStopping() && !this.master.isAborted();
        }
    }
}

