/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.io.hfile.bucket;

import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hadoop.hbase.io.hfile.Cacheable;
import org.apache.hadoop.hbase.io.hfile.CacheableDeserializer;
import org.apache.hadoop.hbase.io.hfile.bucket.FileMmapIOEngine;
import org.apache.hadoop.hbase.nio.SingleByteBuff;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class ExclusiveMemoryMmapIOEngine
extends FileMmapIOEngine {
    static final Logger LOG = LoggerFactory.getLogger(ExclusiveMemoryMmapIOEngine.class);

    public ExclusiveMemoryMmapIOEngine(String filePath, long capacity) throws IOException {
        super(filePath, capacity);
    }

    @Override
    public Cacheable read(long offset, int length, CacheableDeserializer<Cacheable> deserializer) throws IOException {
        byte[] dst = new byte[length];
        this.bufferArray.getMultiple(offset, length, dst);
        return deserializer.deserialize(new SingleByteBuff(ByteBuffer.wrap(dst)), true, Cacheable.MemoryType.EXCLUSIVE);
    }
}

