/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.grpc.schema.util;

import com.google.protobuf.Int64Value;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.graphdb.grpc.types.EdgeLabel;
import org.janusgraph.graphdb.grpc.types.VertexLabel;

public class GrpcUtils {
    public static VertexLabel createVertexLabelProto(org.janusgraph.core.VertexLabel vertexLabel) {
        return VertexLabel.newBuilder().setId(Int64Value.of((long)vertexLabel.longId())).setName(vertexLabel.name()).setPartitioned(vertexLabel.isPartitioned()).setReadOnly(vertexLabel.isStatic()).build();
    }

    public static Multiplicity convertGrpcEdgeMultiplicity(EdgeLabel.Multiplicity multiplicity) {
        switch (multiplicity) {
            case MANY2ONE: {
                return Multiplicity.MANY2ONE;
            }
            case ONE2MANY: {
                return Multiplicity.ONE2MANY;
            }
            case ONE2ONE: {
                return Multiplicity.ONE2ONE;
            }
            case SIMPLE: {
                return Multiplicity.SIMPLE;
            }
        }
        return Multiplicity.MULTI;
    }

    public static EdgeLabel.Multiplicity convertToGrpcMultiplicity(Multiplicity multiplicity) {
        switch (multiplicity) {
            case SIMPLE: {
                return EdgeLabel.Multiplicity.SIMPLE;
            }
            case ONE2MANY: {
                return EdgeLabel.Multiplicity.ONE2MANY;
            }
            case MANY2ONE: {
                return EdgeLabel.Multiplicity.MANY2ONE;
            }
            case ONE2ONE: {
                return EdgeLabel.Multiplicity.ONE2ONE;
            }
        }
        return EdgeLabel.Multiplicity.MULTI;
    }

    public static EdgeLabel createEdgeLabelProto(org.janusgraph.core.EdgeLabel edgeLabel) {
        return EdgeLabel.newBuilder().setId(Int64Value.of((long)edgeLabel.longId())).setName(edgeLabel.name()).setMultiplicity(GrpcUtils.convertToGrpcMultiplicity(edgeLabel.multiplicity())).setDirection(edgeLabel.isDirected() ? EdgeLabel.Direction.BOTH : EdgeLabel.Direction.OUT).build();
    }
}

