/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.typestate;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.flow.AbstractStaticInvokeTypeFlow;
import com.oracle.graal.pointsto.flow.ActualReturnTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import java.util.Collection;
import java.util.Collections;
import jdk.vm.ci.code.BytecodePosition;
import jdk.vm.ci.common.JVMCIError;

final class DefaultStaticInvokeTypeFlow
extends AbstractStaticInvokeTypeFlow {
    DefaultStaticInvokeTypeFlow(BytecodePosition invokeLocation, AnalysisType receiverType, PointsToAnalysisMethod targetMethod, TypeFlow<?>[] actualParameters, ActualReturnTypeFlow actualReturn) {
        super(invokeLocation, receiverType, targetMethod, actualParameters, actualReturn);
    }

    @Override
    public void update(PointsToAnalysis bb) {
        JVMCIError.guarantee((this.callee == null ? 1 : 0) != 0, (String)"static invoke updated multiple times!", (Object[])new Object[0]);
        if (!this.targetMethod.getWrapped().getDeclaringClass().isLinked()) {
            return;
        }
        this.callee = this.targetMethod.getTypeFlow();
        MethodFlowsGraph calleeFlows = this.callee.getOrCreateMethodFlowsGraph(bb, this);
        this.linkCallee(bb, true, calleeFlows);
    }

    @Override
    public Collection<MethodFlowsGraph> getCalleesFlows(PointsToAnalysis bb) {
        if (this.callee == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(this.callee.getMethodFlowsGraph());
    }
}

