/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.graal.pointsto.flow;

import com.oracle.graal.pointsto.PointsToAnalysis;
import com.oracle.graal.pointsto.api.PointstoOptions;
import com.oracle.graal.pointsto.flow.InvokeTypeFlow;
import com.oracle.graal.pointsto.flow.MethodFlowsGraph;
import com.oracle.graal.pointsto.flow.MethodFlowsGraphClone;
import com.oracle.graal.pointsto.flow.MethodTypeFlow;
import com.oracle.graal.pointsto.flow.TypeFlow;
import com.oracle.graal.pointsto.flow.context.AnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContext;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeAnalysisContextPolicy;
import com.oracle.graal.pointsto.flow.context.bytecode.BytecodeSensitiveAnalysisPolicy;
import com.oracle.graal.pointsto.meta.PointsToAnalysisMethod;
import com.oracle.graal.pointsto.typestate.TypeState;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.graalvm.compiler.options.OptionValues;

public class CallSiteSensitiveMethodTypeFlow
extends MethodTypeFlow {
    private final ConcurrentMap<AnalysisContext, MethodFlowsGraph> clonedMethodFlows;
    private final int localCallingContextDepth;

    public CallSiteSensitiveMethodTypeFlow(OptionValues options, PointsToAnalysisMethod method) {
        super(method);
        this.localCallingContextDepth = (Integer)PointstoOptions.MaxCallingContextDepth.getValue(options);
        this.clonedMethodFlows = new ConcurrentHashMap<AnalysisContext, MethodFlowsGraph>(4, 0.75f, 1);
    }

    public MethodFlowsGraph addContext(PointsToAnalysis bb, AnalysisContext calleeContext) {
        return this.addContext(bb, calleeContext, null);
    }

    public MethodFlowsGraph addContext(PointsToAnalysis bb, AnalysisContext calleeContext, InvokeTypeFlow reason) {
        this.ensureFlowsGraphCreated(bb, reason);
        this.getMethodFlowsGraph().ensureLinearized();
        BytecodeAnalysisContextPolicy contextPolicy = ((BytecodeSensitiveAnalysisPolicy)bb.analysisPolicy()).getContextPolicy();
        BytecodeAnalysisContext newContext = contextPolicy.peel((BytecodeAnalysisContext)calleeContext, this.localCallingContextDepth);
        MethodFlowsGraphClone methodFlows = (MethodFlowsGraphClone)this.clonedMethodFlows.get(newContext);
        if (methodFlows == null) {
            MethodFlowsGraphClone newFlows = new MethodFlowsGraphClone(this.method, newContext);
            newFlows.cloneOriginalFlows(bb);
            MethodFlowsGraphClone oldFlows = (MethodFlowsGraphClone)this.clonedMethodFlows.putIfAbsent(newContext, newFlows);
            MethodFlowsGraphClone methodFlowsGraphClone = methodFlows = oldFlows != null ? oldFlows : newFlows;
            if (oldFlows == null) {
                methodFlows.linkClones(bb);
            }
        }
        return methodFlows;
    }

    @Override
    protected void initFlowsGraph(PointsToAnalysis bb) {
    }

    public int getLocalCallingContextDepth() {
        return this.localCallingContextDepth;
    }

    @Override
    public Collection<MethodFlowsGraph> getFlows() {
        return this.clonedMethodFlows.values();
    }

    public MethodFlowsGraph getFlows(AnalysisContext calleeContext) {
        return (MethodFlowsGraph)this.clonedMethodFlows.get(calleeContext);
    }

    @Override
    public TypeState foldTypeFlow(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        if (originalTypeFlow == null) {
            return null;
        }
        TypeState result = TypeState.forEmpty();
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            TypeState cloneState = clonedTypeFlow.getState();
            TypeState cloneStateCopy = bb.analysisPolicy().forContextInsensitiveTypeState(bb, cloneState);
            result = TypeState.forUnion(bb, result, cloneStateCopy);
        }
        return result;
    }

    @Override
    public boolean isSaturated(PointsToAnalysis bb, TypeFlow<?> originalTypeFlow) {
        boolean saturated = false;
        for (MethodFlowsGraph methodFlows : this.clonedMethodFlows.values()) {
            TypeFlow<?> clonedTypeFlow = methodFlows.lookupCloneOf(bb, originalTypeFlow);
            saturated |= clonedTypeFlow.isSaturated();
        }
        return saturated;
    }

    @Override
    public String toString() {
        return "CallSiteSensitiveMethodTypeFlow<" + this.method + ">";
    }
}

