/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.hosted.lambda;

import com.oracle.graal.pointsto.meta.AnalysisType;
import com.oracle.svm.core.SubstrateUtil;
import com.oracle.svm.core.feature.AutomaticallyRegisteredFeature;
import com.oracle.svm.core.feature.InternalFeature;
import com.oracle.svm.hosted.FeatureImpl;
import com.oracle.svm.hosted.lambda.LambdaProxyRenamingSubstitutionProcessor;
import java.util.HashSet;
import java.util.List;
import org.graalvm.compiler.java.LambdaUtils;
import org.graalvm.nativeimage.hosted.Feature;

@AutomaticallyRegisteredFeature
final class StableLambdaProxyNameFeature
implements InternalFeature {
    StableLambdaProxyNameFeature() {
    }

    public void duringSetup(Feature.DuringSetupAccess a) {
        FeatureImpl.DuringSetupAccessImpl access = (FeatureImpl.DuringSetupAccessImpl)a;
        LambdaProxyRenamingSubstitutionProcessor lSubst = new LambdaProxyRenamingSubstitutionProcessor(access.getBigBang());
        access.registerSubstitutionProcessor(lSubst);
    }

    public void afterAnalysis(Feature.AfterAnalysisAccess access) {
        assert (StableLambdaProxyNameFeature.checkLambdaNames(((FeatureImpl.AfterAnalysisAccessImpl)access).getUniverse().getTypes()));
    }

    private static boolean checkLambdaNames(List<AnalysisType> types) {
        if (!SubstrateUtil.assertionsEnabled()) {
            throw new AssertionError((Object)"Expensive check: should only run with assertions enabled.");
        }
        if (types.stream().anyMatch(LambdaUtils::isLambdaType)) {
            throw new AssertionError((Object)"All lambda proxies should be substituted.");
        }
        HashSet lambdaNames = new HashSet();
        types.stream().map(AnalysisType::getName).filter(x -> x.contains("$$Lambda$")).forEach(name -> {
            if (lambdaNames.contains(name)) {
                throw new AssertionError((Object)("Duplicate lambda name: " + name));
            }
            lambdaNames.add(name);
        });
        return true;
    }
}

