/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.svm.core.code;

import com.oracle.svm.core.MemoryWalker;
import com.oracle.svm.core.code.CodeInfo;
import com.oracle.svm.core.code.CodeInfoAccess;
import com.oracle.svm.core.feature.AutomaticallyRegisteredImageSingleton;
import org.graalvm.nativeimage.Platform;
import org.graalvm.nativeimage.Platforms;
import org.graalvm.word.UnsignedWord;

@AutomaticallyRegisteredImageSingleton
final class CodeInfoMemoryWalker
implements MemoryWalker.CodeAccess<CodeInfo> {
    @Platforms(value={Platform.HOSTED_ONLY.class})
    CodeInfoMemoryWalker() {
    }

    @Override
    public UnsignedWord getStart(CodeInfo codeInfo) {
        return (UnsignedWord)CodeInfoAccess.getCodeStart(codeInfo);
    }

    @Override
    public UnsignedWord getCodeAndDataMemorySize(CodeInfo codeInfo) {
        return CodeInfoAccess.getCodeSize(codeInfo).add(CodeInfoAccess.getCodeAndDataMemorySize(codeInfo));
    }

    @Override
    public UnsignedWord getNativeMetadataSize(CodeInfo codeInfo) {
        return CodeInfoAccess.getNativeMetadataSize(codeInfo);
    }

    @Override
    public String getName(CodeInfo codeInfo) {
        return CodeInfoAccess.getName(codeInfo);
    }
}

