/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.types.system;

import com.google.common.base.Preconditions;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.T;
import org.janusgraph.core.Cardinality;
import org.janusgraph.core.JanusGraphProperty;
import org.janusgraph.core.Multiplicity;
import org.janusgraph.core.PropertyKey;
import org.janusgraph.core.schema.ConsistencyModifier;
import org.janusgraph.diskstorage.EntryMetaData;
import org.janusgraph.graphdb.internal.InternalElement;
import org.janusgraph.graphdb.internal.InternalRelation;
import org.janusgraph.graphdb.internal.InternalRelationType;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.InternalVertexLabel;
import org.janusgraph.graphdb.internal.JanusGraphSchemaCategory;
import org.janusgraph.graphdb.internal.Token;
import org.janusgraph.graphdb.types.system.BaseRelationType;
import org.janusgraph.graphdb.types.system.EmptyRelationType;
import org.janusgraph.graphdb.types.system.SystemRelationType;

public class ImplicitKey
extends EmptyRelationType
implements SystemRelationType,
PropertyKey {
    public static final ImplicitKey ID = new ImplicitKey(1001L, T.id.getAccessor(), Object.class);
    public static final ImplicitKey JANUSGRAPHID = new ImplicitKey(1002L, Token.makeSystemName("nid"), Long.class);
    public static final ImplicitKey LABEL = new ImplicitKey(11L, T.label.getAccessor(), String.class);
    public static final ImplicitKey KEY = new ImplicitKey(12L, T.key.getAccessor(), String.class);
    public static final ImplicitKey VALUE = new ImplicitKey(13L, T.value.getAccessor(), Object.class);
    public static final ImplicitKey ADJACENT_ID = new ImplicitKey(1003L, Token.makeSystemName("adjacent"), Long.class);
    public static final ImplicitKey TIMESTAMP = new ImplicitKey(5L, Token.makeSystemName("timestamp"), Instant.class);
    public static final ImplicitKey VISIBILITY = new ImplicitKey(6L, Token.makeSystemName("visibility"), String.class);
    public static final ImplicitKey TTL = new ImplicitKey(7L, Token.makeSystemName("ttl"), Duration.class);
    public static final Map<EntryMetaData, ImplicitKey> MetaData2ImplicitKey = Collections.unmodifiableMap(new HashMap<EntryMetaData, ImplicitKey>(3){
        {
            this.put(EntryMetaData.TIMESTAMP, TIMESTAMP);
            this.put(EntryMetaData.TTL, TTL);
            this.put(EntryMetaData.VISIBILITY, VISIBILITY);
        }
    });
    private final Class<?> datatype;
    private final String name;
    private final long id;

    private ImplicitKey(long id, String name, Class<?> datatype) {
        Preconditions.checkArgument((StringUtils.isNotBlank((CharSequence)name) && datatype != null && id > 0L ? 1 : 0) != 0);
        assert (Token.isSystemName(name));
        this.datatype = datatype;
        this.name = name;
        this.id = BaseRelationType.getSystemTypeId(id, JanusGraphSchemaCategory.PROPERTYKEY);
    }

    public <O> O computeProperty(InternalElement e) {
        if (this == ID) {
            return (O)e.id();
        }
        if (this == JANUSGRAPHID) {
            return (O)Long.valueOf(e.longId());
        }
        if (this == LABEL) {
            return (O)e.label();
        }
        if (this == KEY) {
            if (e instanceof JanusGraphProperty) {
                return (O)((JanusGraphProperty)((Object)e)).key();
            }
            return null;
        }
        if (this == VALUE) {
            if (e instanceof JanusGraphProperty) {
                return (O)((JanusGraphProperty)((Object)e)).value();
            }
            return null;
        }
        if (this == TIMESTAMP || this == VISIBILITY) {
            if (e instanceof InternalRelation) {
                InternalRelation r = (InternalRelation)e;
                if (this == VISIBILITY) {
                    return r.getValueDirect(this);
                }
                assert (this == TIMESTAMP);
                Long time = (Long)r.getValueDirect(this);
                if (time == null) {
                    return null;
                }
                return (O)r.tx().getConfiguration().getTimestampProvider().getTime(time);
            }
            return null;
        }
        if (this == TTL) {
            int ttl = e instanceof InternalRelation ? ((InternalRelationType)((InternalRelation)e).getType()).getTTL() : (e instanceof InternalVertex ? ((InternalVertexLabel)((InternalVertex)e).vertexLabel()).getTTL() : 0);
            return (O)Duration.ofSeconds(ttl);
        }
        throw new AssertionError((Object)("Implicit key property is undefined: " + this.name()));
    }

    @Override
    public Class<?> dataType() {
        return this.datatype;
    }

    @Override
    public Cardinality cardinality() {
        return Cardinality.SINGLE;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean isPropertyKey() {
        return true;
    }

    @Override
    public boolean isEdgeLabel() {
        return false;
    }

    @Override
    public boolean isInvisibleType() {
        return false;
    }

    @Override
    public Multiplicity multiplicity() {
        return Multiplicity.convert(this.cardinality());
    }

    @Override
    public ConsistencyModifier getConsistencyModifier() {
        return ConsistencyModifier.DEFAULT;
    }

    @Override
    public boolean isUnidirected(Direction dir) {
        return dir == Direction.OUT;
    }

    @Override
    public long longId() {
        return this.id;
    }

    @Override
    public boolean hasId() {
        return this.id > 0L;
    }

    @Override
    public void setId(long id) {
        throw new IllegalStateException("SystemType has already been assigned an id");
    }

    @Override
    public String toString() {
        return this.name;
    }
}

