/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.tinkerpop.optimize.step;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.tinkerpop.gremlin.process.traversal.Traversal;
import org.apache.tinkerpop.gremlin.process.traversal.Traverser;
import org.apache.tinkerpop.gremlin.process.traversal.step.util.AbstractStep;
import org.apache.tinkerpop.gremlin.process.traversal.util.FastNoSuchElementException;
import org.apache.tinkerpop.gremlin.structure.Element;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.graphdb.tinkerpop.optimize.step.MultiQueriable;

public final class JanusGraphMultiQueryStep
extends AbstractStep<Element, Element> {
    private List<MultiQueriable> clientSteps = new ArrayList<MultiQueriable>();
    private final boolean limitBatchSize;
    private boolean initialized;

    public JanusGraphMultiQueryStep(Traversal.Admin traversal, boolean limitBatchSize) {
        super(traversal);
        this.limitBatchSize = limitBatchSize;
        this.initialized = false;
    }

    public void attachClient(MultiQueriable mq) {
        this.clientSteps.add(mq);
    }

    private void initialize() {
        assert (!this.initialized);
        this.initialized = true;
        if (!this.limitBatchSize && !this.clientSteps.isEmpty()) {
            if (!this.starts.hasNext()) {
                throw FastNoSuchElementException.instance();
            }
            ArrayList elements = new ArrayList();
            this.starts.forEachRemaining(e -> {
                elements.add(e);
                if (e.get() instanceof Vertex) {
                    this.clientSteps.forEach(client -> client.registerFutureVertexForPrefetching((Vertex)e.get()));
                }
            });
            this.starts.add(elements.iterator());
        }
    }

    protected Traverser.Admin<Element> processNextStart() throws NoSuchElementException {
        Traverser.Admin start;
        if (!this.initialized) {
            this.initialize();
        }
        if ((start = this.starts.next()).get() instanceof Vertex) {
            this.clientSteps.forEach(client -> client.registerFutureVertexForPrefetching((Vertex)start.get()));
        }
        return start;
    }

    public JanusGraphMultiQueryStep clone() {
        JanusGraphMultiQueryStep clone = (JanusGraphMultiQueryStep)super.clone();
        clone.clientSteps = new ArrayList<MultiQueriable>(this.clientSteps);
        clone.initialized = false;
        return clone;
    }

    public void reset() {
        super.reset();
        this.initialized = false;
    }

    public boolean isLimitBatchSize() {
        return this.limitBatchSize;
    }

    public List<MultiQueriable> getClientSteps() {
        return Collections.unmodifiableList(this.clientSteps);
    }
}

