/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.query.vertex;

import com.google.common.base.Preconditions;
import java.util.List;
import org.janusgraph.core.JanusGraphEdge;
import org.janusgraph.core.JanusGraphRelation;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.JanusGraphVertexProperty;
import org.janusgraph.core.JanusGraphVertexQuery;
import org.janusgraph.core.VertexList;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.graphdb.internal.InternalVertex;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.query.BackendQueryHolder;
import org.janusgraph.graphdb.query.vertex.BaseVertexCentricQuery;
import org.janusgraph.graphdb.query.vertex.BasicVertexCentricQueryBuilder;

public class VertexCentricQueryBuilder
extends BasicVertexCentricQueryBuilder<VertexCentricQueryBuilder>
implements JanusGraphVertexQuery<VertexCentricQueryBuilder> {
    private final InternalVertex vertex;

    public VertexCentricQueryBuilder(InternalVertex v) {
        super(v.tx());
        Preconditions.checkNotNull((Object)v);
        this.vertex = v;
    }

    @Override
    protected VertexCentricQueryBuilder getThis() {
        return this;
    }

    protected <Q> Q execute(RelationCategory returnType, BasicVertexCentricQueryBuilder.ResultConstructor<Q> resultConstructor) {
        BaseVertexCentricQuery bq = super.constructQuery(returnType);
        if (bq.isEmpty()) {
            return resultConstructor.emptyResult();
        }
        if (returnType == RelationCategory.PROPERTY && this.hasSingleType() && !this.hasQueryOnlyLoaded() && this.tx.getConfiguration().hasPropertyPrefetching()) {
            this.vertex.query().properties().iterator().hasNext();
        }
        if (this.isPartitionedVertex(this.vertex) && !this.hasQueryOnlyGivenVertex()) {
            List<InternalVertex> vertices = this.allRequiredRepresentatives(this.vertex);
            this.profiler.setAnnotation("partitioned", true);
            this.profiler.setAnnotation("vertices", vertices.size());
            if (vertices.size() > 1) {
                for (BackendQueryHolder<SliceQuery> sq : bq.getQueries()) {
                    this.tx.executeMultiQuery(vertices, sq.getBackendQuery(), sq.getProfiler());
                }
            }
        } else {
            this.profiler.setAnnotation("vertices", 1);
        }
        return resultConstructor.getResult(this.vertex, bq);
    }

    @Override
    public Iterable<JanusGraphEdge> edges() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<JanusGraphVertexProperty> properties() {
        return this.isImplicitKeyQuery(RelationCategory.PROPERTY) ? this.executeImplicitKeyQuery(this.vertex) : this.execute(RelationCategory.PROPERTY, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<JanusGraphRelation> relations() {
        return this.isImplicitKeyQuery(RelationCategory.RELATION) ? this.executeImplicitKeyQuery(this.vertex) : this.execute(RelationCategory.RELATION, new BasicVertexCentricQueryBuilder.RelationConstructor(this));
    }

    @Override
    public Iterable<JanusGraphVertex> vertices() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexConstructor(this));
    }

    @Override
    public VertexList vertexIds() {
        return this.execute(RelationCategory.EDGE, new BasicVertexCentricQueryBuilder.VertexIdConstructor(this));
    }
}

