/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.graphdb.olap.computer;

import java.io.Closeable;
import java.util.List;
import java.util.Set;
import org.apache.tinkerpop.gremlin.process.computer.Memory;
import org.apache.tinkerpop.gremlin.process.computer.MessageScope;
import org.apache.tinkerpop.gremlin.process.computer.VertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.clustering.connected.ConnectedComponentVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.search.path.ShortestPathVertexProgram;
import org.apache.tinkerpop.gremlin.process.computer.traversal.TraversalVertexProgram;
import org.apache.tinkerpop.gremlin.structure.Direction;
import org.apache.tinkerpop.gremlin.structure.Vertex;
import org.janusgraph.core.JanusGraph;
import org.janusgraph.core.JanusGraphVertex;
import org.janusgraph.core.ReadOnlyTransactionException;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.scan.ScanMetrics;
import org.janusgraph.graphdb.database.StandardJanusGraph;
import org.janusgraph.graphdb.database.idhandling.IDHandler;
import org.janusgraph.graphdb.idmanagement.IDManager;
import org.janusgraph.graphdb.internal.RelationCategory;
import org.janusgraph.graphdb.olap.QueryContainer;
import org.janusgraph.graphdb.olap.VertexJobConverter;
import org.janusgraph.graphdb.olap.VertexScanJob;
import org.janusgraph.graphdb.olap.computer.FulgoraMemory;
import org.janusgraph.graphdb.olap.computer.FulgoraUtil;
import org.janusgraph.graphdb.olap.computer.FulgoraVertexMemory;
import org.janusgraph.graphdb.olap.computer.VertexMemoryHandler;
import org.janusgraph.graphdb.tinkerpop.optimize.step.JanusGraphVertexStep;
import org.janusgraph.graphdb.vertices.PreloadedVertex;

public class VertexProgramScanJob<M>
implements VertexScanJob {
    private static final MessageScope.Global globalScope = MessageScope.Global.instance();
    private final IDManager idManager;
    private final FulgoraMemory memory;
    private final FulgoraVertexMemory<M> vertexMemory;
    private final VertexProgram<M> vertexProgram;
    static final SliceQuery SYSTEM_PROPS_QUERY = new SliceQuery(IDHandler.getBounds(RelationCategory.PROPERTY, true)[0], IDHandler.getBounds(RelationCategory.PROPERTY, false)[1]);

    private VertexProgramScanJob(IDManager idManager, FulgoraMemory memory, FulgoraVertexMemory vertexMemory, VertexProgram<M> vertexProgram) {
        this.idManager = idManager;
        this.memory = memory;
        this.vertexMemory = vertexMemory;
        this.vertexProgram = vertexProgram;
    }

    @Override
    public VertexProgramScanJob<M> clone() {
        return new VertexProgramScanJob<M>(this.idManager, this.memory, this.vertexMemory, this.vertexProgram.clone());
    }

    @Override
    public void workerIterationStart(JanusGraph graph, Configuration config, ScanMetrics metrics) {
        this.vertexProgram.workerIterationStart(this.memory.asImmutable());
    }

    @Override
    public void workerIterationEnd(ScanMetrics metrics) {
        this.vertexProgram.workerIterationEnd(this.memory.asImmutable());
    }

    @Override
    public void process(JanusGraphVertex vertex, ScanMetrics metrics) {
        PreloadedVertex v = (PreloadedVertex)vertex;
        long vertexId = v.longId();
        VertexMemoryHandler<M> vh = new VertexMemoryHandler<M>(this.vertexMemory, v);
        vh.setInExecute(true);
        v.setAccessCheck(PreloadedVertex.OPENSTAR_CHECK);
        if (this.idManager.isPartitionedVertex(vertexId)) {
            if (this.idManager.isCanonicalVertexId(vertexId)) {
                EntryList results = v.getFromCache(SYSTEM_PROPS_QUERY);
                if (results == null) {
                    results = EntryList.EMPTY_LIST;
                }
                this.vertexMemory.setLoadedProperties(vertexId, results);
            }
            for (MessageScope scope : this.vertexMemory.getPreviousScopes()) {
                if (!(scope instanceof MessageScope.Local)) continue;
                vh.receiveMessages(scope).iterator().forEachRemaining(m -> this.vertexMemory.aggregateMessage(vertexId, m, scope));
            }
        } else {
            v.setPropertyMixing(vh);
            try {
                this.vertexProgram.execute((Vertex)v, vh, (Memory)this.memory);
            }
            catch (ReadOnlyTransactionException readOnlyTransactionException) {
                // empty catch block
            }
        }
        vh.setInExecute(false);
    }

    @Override
    public void getQueries(QueryContainer queries) {
        Set<MessageScope> previousScopes = this.vertexMemory.getPreviousScopes();
        if (this.vertexProgram instanceof TraversalVertexProgram || this.vertexProgram instanceof ShortestPathVertexProgram || this.vertexProgram instanceof ConnectedComponentVertexProgram || previousScopes.contains(globalScope)) {
            queries.addQuery().direction(Direction.BOTH).edges();
        }
        for (MessageScope scope : previousScopes) {
            if (!(scope instanceof MessageScope.Local)) continue;
            JanusGraphVertexStep<Vertex> startStep = FulgoraUtil.getReverseJanusGraphVertexStep((MessageScope.Local)scope, queries.getTransaction());
            QueryContainer.QueryBuilder qb = queries.addQuery();
            startStep.makeQuery(qb);
            qb.edges();
        }
    }

    public static <M> Executor getVertexProgramScanJob(StandardJanusGraph graph, FulgoraMemory memory, FulgoraVertexMemory vertexMemory, VertexProgram<M> vertexProgram) {
        VertexProgramScanJob<M> job = new VertexProgramScanJob<M>(graph.getIDManager(), memory, vertexMemory, vertexProgram);
        return new Executor(graph, job);
    }

    public static class Executor
    extends VertexJobConverter
    implements Closeable {
        private Executor(JanusGraph graph, VertexProgramScanJob job) {
            super(graph, job);
            this.open(this.graph.get().getConfiguration().getConfiguration());
        }

        private Executor(Executor copy) {
            super(copy);
            this.open(this.graph.get().getConfiguration().getConfiguration());
        }

        @Override
        public List<SliceQuery> getQueries() {
            List<SliceQuery> queries = super.getQueries();
            queries.add(SYSTEM_PROPS_QUERY);
            return queries;
        }

        @Override
        public void workerIterationStart(Configuration jobConfig, Configuration graphConfig, ScanMetrics metrics) {
            this.job.workerIterationStart(this.graph.get(), jobConfig, metrics);
        }

        @Override
        public void workerIterationEnd(ScanMetrics metrics) {
            this.job.workerIterationEnd(metrics);
        }

        @Override
        public Executor clone() {
            return new Executor(this);
        }

        @Override
        public void close() {
            super.close();
        }
    }
}

