/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.util;

import com.codahale.metrics.Timer;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.janusgraph.diskstorage.BackendException;
import org.janusgraph.diskstorage.Entry;
import org.janusgraph.diskstorage.EntryList;
import org.janusgraph.diskstorage.StaticBuffer;
import org.janusgraph.diskstorage.keycolumnvalue.KeyColumnValueStore;
import org.janusgraph.diskstorage.keycolumnvalue.KeyIterator;
import org.janusgraph.diskstorage.keycolumnvalue.KeyRangeQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.KeySlicesIterator;
import org.janusgraph.diskstorage.keycolumnvalue.MultiSlicesQuery;
import org.janusgraph.diskstorage.keycolumnvalue.SliceQuery;
import org.janusgraph.diskstorage.keycolumnvalue.StoreTransaction;
import org.janusgraph.diskstorage.util.IOCallable;
import org.janusgraph.diskstorage.util.MetricInstrumentedIterator;
import org.janusgraph.diskstorage.util.MetricInstrumentedSlicesIterator;
import org.janusgraph.diskstorage.util.StorageCallable;
import org.janusgraph.diskstorage.util.UncheckedCallable;
import org.janusgraph.util.stats.MetricManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MetricInstrumentedStore
implements KeyColumnValueStore {
    private final KeyColumnValueStore backend;
    private static final Logger log = LoggerFactory.getLogger(MetricInstrumentedStore.class);
    public static final String M_CONTAINS_KEY = "containsKey";
    public static final String M_GET_SLICE = "getSlice";
    public static final String M_MUTATE = "mutate";
    public static final String M_ACQUIRE_LOCK = "acquireLock";
    public static final String M_GET_KEYS = "getKeys";
    public static final String M_GET_PART = "getLocalKeyPartition";
    public static final String M_CLOSE = "close";
    public static final List<String> OPERATION_NAMES = Collections.unmodifiableList(Arrays.asList("containsKey", "getSlice", "mutate", "acquireLock", "getKeys"));
    public static final String M_CALLS = "calls";
    public static final String M_TIME = "time";
    public static final String M_EXCEPTIONS = "exceptions";
    public static final String M_ENTRIES_COUNT = "entries-returned";
    public static final String M_ENTRIES_HISTO = "entries-histogram";
    public static final List<String> EVENT_NAMES = Collections.unmodifiableList(Arrays.asList("calls", "time", "exceptions", "entries-returned", "entries-histogram"));
    public static final String M_ITERATOR = "iterator";
    private final String metricsStoreName;

    public MetricInstrumentedStore(KeyColumnValueStore backend, String metricsStoreName) {
        this.backend = backend;
        this.metricsStoreName = metricsStoreName;
        log.debug("Wrapped Metrics named \"{}\" around store {}", (Object)metricsStoreName, (Object)backend);
    }

    @Override
    public EntryList getSlice(KeySliceQuery query, StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_SLICE, () -> {
            EntryList result = this.backend.getSlice(query, txh);
            this.recordSliceMetrics(txh, result);
            return result;
        });
    }

    @Override
    public Map<StaticBuffer, EntryList> getSlice(List<StaticBuffer> keys, SliceQuery query, StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_SLICE, () -> {
            Map<StaticBuffer, EntryList> results = this.backend.getSlice(keys, query, txh);
            for (EntryList result : results.values()) {
                this.recordSliceMetrics(txh, result);
            }
            return results;
        });
    }

    @Override
    public void mutate(StaticBuffer key, List<Entry> additions, List<StaticBuffer> deletions, StoreTransaction txh) throws BackendException {
        MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_MUTATE, () -> {
            this.backend.mutate(key, additions, deletions, txh);
            return null;
        });
    }

    @Override
    public void acquireLock(StaticBuffer key, StaticBuffer column, StaticBuffer expectedValue, StoreTransaction txh) throws BackendException {
        MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_ACQUIRE_LOCK, () -> {
            this.backend.acquireLock(key, column, expectedValue, txh);
            return null;
        });
    }

    @Override
    public KeyIterator getKeys(KeyRangeQuery query, StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_KEYS, () -> {
            KeyIterator ki = this.backend.getKeys(query, txh);
            if (txh.getConfiguration().hasGroupName()) {
                return MetricInstrumentedIterator.of(ki, txh.getConfiguration().getGroupName(), this.metricsStoreName, M_GET_KEYS, M_ITERATOR);
            }
            return ki;
        });
    }

    @Override
    public KeyIterator getKeys(SliceQuery query, StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_KEYS, () -> {
            KeyIterator ki = this.backend.getKeys(query, txh);
            if (txh.getConfiguration().hasGroupName()) {
                return MetricInstrumentedIterator.of(ki, txh.getConfiguration().getGroupName(), this.metricsStoreName, M_GET_KEYS, M_ITERATOR);
            }
            return ki;
        });
    }

    @Override
    public KeySlicesIterator getKeys(MultiSlicesQuery queries, StoreTransaction txh) throws BackendException {
        return MetricInstrumentedStore.runWithMetrics(txh, this.metricsStoreName, M_GET_KEYS, () -> {
            KeySlicesIterator ki = this.backend.getKeys(queries, txh);
            if (txh.getConfiguration().hasGroupName()) {
                return MetricInstrumentedSlicesIterator.of(ki, txh.getConfiguration().getGroupName(), this.metricsStoreName, M_GET_KEYS, M_ITERATOR);
            }
            return ki;
        });
    }

    @Override
    public String getName() {
        return this.backend.getName();
    }

    @Override
    public void close() throws BackendException {
        this.backend.close();
    }

    private void recordSliceMetrics(StoreTransaction txh, List<Entry> row) {
        if (!txh.getConfiguration().hasGroupName()) {
            return;
        }
        String p = txh.getConfiguration().getGroupName();
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(p, this.metricsStoreName, M_GET_SLICE, M_ENTRIES_COUNT).inc((long)row.size());
        mgr.getHistogram(p, this.metricsStoreName, M_GET_SLICE, M_ENTRIES_HISTO).update(row.size());
    }

    static <T> T runWithMetrics(StoreTransaction txh, String storeName, String name, StorageCallable<T> impl) throws BackendException {
        if (!txh.getConfiguration().hasGroupName()) {
            return impl.call();
        }
        String prefix = txh.getConfiguration().getGroupName();
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, storeName, name, M_CALLS).inc();
        Timer.Context tc = mgr.getTimer(prefix, storeName, name, M_TIME).time();
        try {
            T t = impl.call();
            return t;
        }
        catch (RuntimeException | BackendException e) {
            mgr.getCounter(prefix, storeName, name, M_EXCEPTIONS).inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    static <T> void runWithMetrics(String prefix, String name, IOCallable<T> impl) throws IOException {
        if (null == prefix) {
            impl.call();
            return;
        }
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, null, M_CLOSE, M_CALLS).inc();
        Timer.Context tc = mgr.getTimer(prefix, null, M_CLOSE, M_TIME).time();
        try {
            impl.call();
        }
        catch (IOException e) {
            mgr.getCounter(prefix, null, M_CLOSE, M_EXCEPTIONS).inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }

    static <T> T runWithMetrics(String prefix, String name, UncheckedCallable<T> impl) {
        if (null == prefix) {
            return impl.call();
        }
        Preconditions.checkNotNull((Object)name);
        Preconditions.checkNotNull(impl);
        MetricManager mgr = MetricManager.INSTANCE;
        mgr.getCounter(prefix, null, name, M_CALLS).inc();
        Timer.Context tc = mgr.getTimer(prefix, null, name, M_TIME).time();
        try {
            T t = impl.call();
            return t;
        }
        catch (RuntimeException e) {
            mgr.getCounter(prefix, null, name, M_EXCEPTIONS).inc();
            throw e;
        }
        finally {
            tc.stop();
        }
    }
}

