/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.libgraal;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotSpeculationLog;
import jdk.vm.ci.services.Services;
import org.graalvm.libgraal.LibGraalScope;

public class LibGraal {
    private static final Method unhand;
    private static final Method translate;
    private static final Method registerNativeMethods;
    private static final Method isCurrentThreadAttached;
    private static final Method attachCurrentThread;
    private static final Method detachCurrentThread;
    private static final Method getFailedSpeculationsAddress;
    static final long initialIsolate;
    static final boolean available;

    public static boolean isAvailable() {
        return LibGraal.inLibGraal() || available;
    }

    public static boolean isSupported() {
        return getFailedSpeculationsAddress != null;
    }

    public static boolean inLibGraal() {
        return Services.IS_IN_NATIVE_IMAGE;
    }

    public static void registerNativeMethods(Class<?> clazz) {
        if (clazz.isPrimitive()) {
            throw new IllegalArgumentException();
        }
        if (LibGraal.inLibGraal() || !LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        try {
            registerNativeMethods.invoke((Object)HotSpotJVMCIRuntime.runtime(), clazz);
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static long translate(Object obj) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        try {
            return (Long)translate.invoke((Object)HotSpotJVMCIRuntime.runtime(), obj);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static <T> T unhand(Class<T> type, long handle) {
        if (!LibGraal.isAvailable()) {
            throw new IllegalStateException();
        }
        try {
            return (T)unhand.invoke((Object)HotSpotJVMCIRuntime.runtime(), type, handle);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    private static long initializeLibgraal() {
        if (registerNativeMethods == null) {
            return 0L;
        }
        try {
            long[] javaVMInfo = (long[])registerNativeMethods.invoke((Object)HotSpotJVMCIRuntime.runtime(), LibGraalScope.class);
            long isolate = javaVMInfo[1];
            return isolate;
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof UnsupportedOperationException) {
                return 0L;
            }
            throw new InternalError(e);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    static boolean isCurrentThreadAttached() {
        try {
            return (Boolean)isCurrentThreadAttached.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static boolean attachCurrentThread(boolean isDaemon, long[] isolate) {
        try {
            if (attachCurrentThread.getParameterCount() == 2) {
                long[] javaVMInfo = isolate != null ? new long[4] : null;
                boolean res = (Boolean)attachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), isDaemon, javaVMInfo);
                if (isolate != null) {
                    isolate[0] = javaVMInfo[1];
                }
                return res;
            }
            if (isolate != null) {
                isolate[0] = initialIsolate;
            }
            return (Boolean)attachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), isDaemon);
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static boolean detachCurrentThread(boolean release) {
        try {
            if (detachCurrentThread.getParameterCount() == 1) {
                return (Boolean)detachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), release);
            }
            detachCurrentThread.invoke((Object)HotSpotJVMCIRuntime.runtime(), new Object[0]);
            return false;
        }
        catch (Throwable throwable) {
            throw new InternalError(throwable);
        }
    }

    public static long getFailedSpeculationsAddress(HotSpotSpeculationLog log) {
        if (getFailedSpeculationsAddress != null) {
            try {
                return (Long)getFailedSpeculationsAddress.invoke((Object)log, new Object[0]);
            }
            catch (Throwable e) {
                throw new InternalError(e);
            }
        }
        throw new UnsupportedOperationException();
    }

    private static Class<?>[] sig(Class<?> ... types) {
        return types;
    }

    private static Method method(Class<?> declaringClass, String name, Class<?>[] ... sigs) {
        if (sigs.length == 1 || sigs.length == 0) {
            try {
                Class[] sig = sigs.length == 1 ? sigs[0] : new Class[]{};
                return declaringClass.getDeclaredMethod(name, sig);
            }
            catch (NoSuchMethodException | SecurityException e) {
                throw (NoSuchMethodError)new NoSuchMethodError(name).initCause(e);
            }
        }
        Method match = null;
        for (Method m : declaringClass.getDeclaredMethods()) {
            if (!m.getName().equals(name)) continue;
            if (match != null) {
                throw new InternalError(String.format("Expected single method named %s, found %s and %s", name, match, m));
            }
            match = m;
        }
        if (match == null) {
            throw new NoSuchMethodError("Cannot find method " + name + " in " + declaringClass.getName());
        }
        Object[] parameterTypes = match.getParameterTypes();
        for (Object[] objectArray : sigs) {
            if (!Arrays.equals(parameterTypes, objectArray)) continue;
            return match;
        }
        throw new NoSuchMethodError(String.format("Unexpected signature for %s: %s", name, Arrays.toString(parameterTypes)));
    }

    private static Method methodOrNull(Class<?> declaringClass, String name, Class<?>[] ... sigs) {
        try {
            return LibGraal.method(declaringClass, name, sigs);
        }
        catch (NoSuchMethodError e) {
            return null;
        }
    }

    private static Method methodIf(Object guard, Class<?> declaringClass, String name, Class<?>[] ... sigs) {
        if (guard == null) {
            return null;
        }
        return LibGraal.method(declaringClass, name, sigs);
    }

    static {
        Services.initializeJVMCI();
        unhand = LibGraal.methodOrNull(HotSpotJVMCIRuntime.class, "unhand", new Class[][]{LibGraal.sig(Class.class, Long.TYPE)});
        translate = LibGraal.methodIf(unhand, HotSpotJVMCIRuntime.class, "translate", new Class[][]{LibGraal.sig(Object.class)});
        registerNativeMethods = LibGraal.methodIf(unhand, HotSpotJVMCIRuntime.class, "registerNativeMethods", new Class[][]{LibGraal.sig(Class.class)});
        isCurrentThreadAttached = LibGraal.methodIf(unhand, HotSpotJVMCIRuntime.class, "isCurrentThreadAttached", new Class[0][]);
        attachCurrentThread = LibGraal.methodIf(unhand, HotSpotJVMCIRuntime.class, "attachCurrentThread", LibGraal.sig(Boolean.TYPE, long[].class), LibGraal.sig(Boolean.TYPE));
        detachCurrentThread = LibGraal.methodIf(unhand, HotSpotJVMCIRuntime.class, "detachCurrentThread", LibGraal.sig(Boolean.TYPE), LibGraal.sig(new Class[0]));
        getFailedSpeculationsAddress = LibGraal.methodIf(unhand, HotSpotSpeculationLog.class, "getFailedSpeculationsAddress", new Class[0][]);
        initialIsolate = Services.IS_BUILDING_NATIVE_IMAGE ? 0L : LibGraal.initializeLibgraal();
        available = initialIsolate != 0L;
    }
}

