/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.virtual.phases.ea;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import org.graalvm.compiler.debug.DebugContext;
import org.graalvm.compiler.debug.GraalError;
import org.graalvm.compiler.graph.Node;
import org.graalvm.compiler.nodes.StructuredGraph;

public class EffectList
implements Iterable<Effect> {
    private static final Effect[] EMPTY_ARRAY = new Effect[0];
    private final DebugContext debug;
    private Effect[] effects = EMPTY_ARRAY;
    private int size;

    public EffectList(DebugContext debug) {
        this.debug = debug;
    }

    private void enlarge(int elements) {
        int length = this.effects.length;
        if (this.size + elements > length) {
            while (this.size + elements > length) {
                length = Math.max(length * 2, 4);
            }
            this.effects = Arrays.copyOf(this.effects, length);
        }
    }

    public void add(SimpleEffect effect) {
        this.add((Effect)effect);
    }

    public void add(Effect effect) {
        assert (effect != null);
        this.enlarge(1);
        this.effects[this.size++] = effect;
    }

    public void addAll(EffectList list) {
        this.enlarge(list.size);
        System.arraycopy(list.effects, 0, this.effects, this.size, list.size);
        this.size += list.size;
    }

    public void insertAll(EffectList list, int position) {
        assert (position >= 0 && position <= this.size);
        this.enlarge(list.size);
        System.arraycopy(this.effects, position, this.effects, position + list.size, this.size - position);
        System.arraycopy(list.effects, 0, this.effects, position, list.size);
        this.size += list.size;
    }

    public int size() {
        return this.size;
    }

    @Override
    public Iterator<Effect> iterator() {
        return new Iterator<Effect>(){
            int index;
            final int listSize;
            {
                this.listSize = EffectList.this.size;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.listSize;
            }

            @Override
            public Effect next() {
                return EffectList.this.effects[this.index++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public Effect get(int index) {
        if (index >= this.size) {
            throw new IndexOutOfBoundsException();
        }
        return this.effects[index];
    }

    public void clear() {
        this.size = 0;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes, boolean cfgKills) {
        boolean message = false;
        for (int i = 0; i < this.size(); ++i) {
            Effect effect = this.effects[i];
            if (effect.isCfgKill() != cfgKills) continue;
            if (!message) {
                message = true;
                this.debug.log(cfgKills ? " ==== cfg kill effects" : " ==== effects");
            }
            try {
                effect.apply(graph, obsoleteNodes);
            }
            catch (Throwable t) {
                throw new GraalError(t).addContext("effect", effect);
            }
            if (!effect.isVisible() || !this.debug.isLogEnabled()) continue;
            this.debug.log("    %s", effect);
        }
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            Effect effect = this.get(i);
            if (!effect.isVisible()) continue;
            str.append(this.effects[i]);
            str.append('\n');
        }
        return str.toString();
    }

    public static abstract class SimpleEffect
    extends Effect {
        public SimpleEffect(String name) {
            super(name);
        }

        @Override
        void apply(StructuredGraph graph, ArrayList<Node> obsoleteNodes) {
            this.apply(graph);
        }

        abstract void apply(StructuredGraph var1);
    }

    public static abstract class Effect {
        private final String name;

        public Effect(String name) {
            this.name = name;
        }

        boolean isVisible() {
            return true;
        }

        boolean isCfgKill() {
            return false;
        }

        abstract void apply(StructuredGraph var1, ArrayList<Node> var2);

        public final String toString() {
            StringBuilder str = new StringBuilder();
            str.append(this.name).append(" [");
            this.format(str);
            str.append(']');
            return str.toString();
        }

        abstract void format(StringBuilder var1);

        void format(StringBuilder str, String[] valueNames, Object[] values) {
            boolean first = true;
            for (int i = 0; i < valueNames.length; ++i) {
                str.append(first ? "" : ", ").append(valueNames[i]).append("=").append(Effect.formatObject(values[i]));
                first = false;
            }
        }

        private static String formatObject(Object object) {
            if (object != null && Object[].class.isAssignableFrom(object.getClass())) {
                return Arrays.toString((Object[])object);
            }
            return String.valueOf(object);
        }
    }
}

