/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.compiler.truffle.runtime.hotspot;

import com.oracle.truffle.api.TruffleRuntime;
import com.oracle.truffle.api.TruffleRuntimeAccess;
import com.oracle.truffle.api.impl.DefaultTruffleRuntime;
import jdk.vm.ci.hotspot.HotSpotJVMCIRuntime;
import jdk.vm.ci.hotspot.HotSpotVMConfigAccess;
import jdk.vm.ci.runtime.JVMCI;
import jdk.vm.ci.services.Services;

public abstract class AbstractHotSpotTruffleRuntimeAccess
implements TruffleRuntimeAccess {
    public TruffleRuntime getRuntime() {
        Services.initializeJVMCI();
        HotSpotJVMCIRuntime hsRuntime = (HotSpotJVMCIRuntime)JVMCI.getRuntime();
        HotSpotVMConfigAccess config = new HotSpotVMConfigAccess(hsRuntime.getConfigStore());
        boolean useCompiler = (Boolean)config.getFlag("UseCompiler", Boolean.class);
        if (!useCompiler) {
            return new DefaultTruffleRuntime();
        }
        return this.createRuntime();
    }

    protected abstract TruffleRuntime createRuntime();
}

